import React, { useState, useRef } from 'react';
import { Modal, notification, Form } from 'antd';
import Upload from './CustomUpload';
import { formItemLayout } from '../data';
import { apiUploadSupplementaryBill } from '../service';

/**
 * 上传发票弹窗
 * */
const UploadInvoiceModal = props => {
  const { id } = props;
  const refForm = useRef();

  const onConfirm = async () => {
    const res = await refForm.current?.validateFields?.();
    if (res?.fileList?.length) {
      const { fileList } = res;
      const params = {
        filePath: fileList[0].url,
        fileName: fileList[0]?.name || '',
        id,
      };
      const data = await apiUploadSupplementaryBill(params);
      if (data.businessCode === '0000') {
        notification.success({ message: '上传成功' });
        props.onCancel(true);
      }
    }
  };

  return (
    <Modal width={500} title="补充发票" open onOk={onConfirm} onCancel={props.onCancel}>
      <Form ref={refForm} {...formItemLayout}>
        <Form.Item
          label="上传发票"
          name="fileList"
          rules={[{ required: true }]}
          extra="支持格式：pdf | doc | docx | png | jpeg | jpg | zip | rar"
        >
          <Upload limit={1} />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default UploadInvoiceModal;
