import { Button, Tag, Popover } from 'antd';
import React from 'react';
import styles from './index.less';

export function columns(res) {
  return [
    {
      title: 'ID',
      dataIndex: 'id',
      key: 'id',
      width: 80,
      align: 'center',
    },
    {
      title: '名称',
      dataIndex: 'templateName',
      width: 200,
      key: 'templateName',
      align: 'center',
    },
    {
      title: '地址',
      dataIndex: 'areaNameList',
      key: 'areaNameList',
      align: 'center',
      width: 500,
      render: (_, row) => {
        const data = row.areaNameList?.join(',');
        const content = <p className={styles.content}>{data}</p>;
        return (
          <Popover content={content} title="不支持配送区域" trigger="hover">
            <p className={styles.p}>{data}</p>
          </Popover>
        );
      },
    },
    {
      title: '操作',
      dataIndex: 'option',
      valueType: 'option',
      key: 'option',
      align: 'center',
      width: 100,
      render: (_, row) => {
        if (!res.canEditable) {
          return '-';
        }
        return (
          <div className={styles.option}>
            <Button type="primary" onClick={() => res.edit(0, row)}>
              复制
            </Button>
            <Button type="primary" onClick={() => res.edit(1, row)}>
              编辑
            </Button>
          </div>
        );
      },
    },
  ];
}

export const treeDataList = [
  {
    title: '0-0',
    key: '0-0',
    level: 1,
    children: [
      {
        title: '0-0-0',
        key: '0-0-0',
        level: 2,
        children: [
          { title: '0-0-0-0', key: '0-0-0-0', level: 3 },
          { title: '0-0-0-1', key: '0-0-0-1', level: 3 },
          { title: '0-0-0-2', key: '0-0-0-2', level: 3 },
        ],
      },
      // {
      //   title: '0-0-1',
      //   key: '0-0-1',
      //   level: 2,
      //   children: [
      //     { title: '0-0-1-0', key: '0-0-1-0', level: 3 },
      //     { title: '0-0-1-1', key: '0-0-1-1', level: 3 },
      //     { title: '0-0-1-2', key: '0-0-1-2', level: 3 },
      //   ],
      // },
      // {
      //   title: '0-0-2',
      //   key: '0-0-2',
      //   level: 2,
      // },
    ],
  },
  // {
  //   title: '0-1',
  //   key: '0-1',
  //   level: 1,
  //   children: [
  //     { title: '0-1-0-0', key: '0-1-0-0', level: 2 },
  //     { title: '0-1-0-1', key: '0-1-0-1', level: 2 },
  //     { title: '0-1-0-2', key: '0-1-0-2', level: 2 },
  //   ],
  // },
  // {
  //   title: '0-2',
  //   key: '0-2',
  //   level: 1,
  //   children: [
  //     {
  //       title: '0-2-0',
  //       key: '0-2-0',
  //       level: 2,
  //       children: [
  //         { title: '0-2-0-0', key: '0-2-0-0', level: 3 },
  //         { title: '0-2-0-1', key: '0-2-0-1', level: 3 },
  //         { title: '0-2-0-2', key: '0-2-0-2', level: 3 },
  //       ],
  //     },
  //     {
  //       title: '0-2-1',
  //       key: '0-2-1',
  //       level: 2,
  //       children: [
  //         { title: '0-2-1-0', key: '0-2-1-0', level: 3 },
  //         { title: '0-2-1-1', key: '0-2-1-1', level: 3 },
  //         { title: '0-2-1-2', key: '0-2-1-2', level: 3 },
  //       ],
  //     },
  //     {
  //       title: '0-2-2',
  //       key: '0-2-2',
  //       level: 2,
  //     },
  //   ],
  // },
  // {
  //   title: '0-2',
  //   key: '0-2',
  //   level: 1,
  //   children: [
  //     {
  //       title: '0-2-0',
  //       key: '0-2-0',
  //       level: 2,
  //       children: [
  //         { title: '0-2-0-0', key: '0-2-0-0', level: 3 },
  //         { title: '0-2-0-1', key: '0-2-0-1', level: 3 },
  //         { title: '0-2-0-2', key: '0-2-0-2', level: 3 },
  //       ],
  //     },
  //     {
  //       title: '0-2-1',
  //       key: '0-2-1',
  //       level: 2,
  //       children: [
  //         { title: '0-2-1-0', key: '0-2-1-0', level: 3 },
  //         { title: '0-2-1-1', key: '0-2-1-1', level: 3 },
  //         { title: '0-2-1-2', key: '0-2-1-2', level: 3 },
  //       ],
  //     },
  //     {
  //       title: '0-2-2',
  //       key: '0-2-2',
  //       level: 2,
  //     },
  //   ],
  // },
  // {
  //   title: '0-2',
  //   key: '0-2',
  //   level: 1,
  //   children: [
  //     {
  //       title: '0-2-0',
  //       key: '0-2-0',
  //       level: 2,
  //       children: [
  //         { title: '0-2-0-0', key: '0-2-0-0', level: 3 },
  //         { title: '0-2-0-1', key: '0-2-0-1', level: 3 },
  //         { title: '0-2-0-2', key: '0-2-0-2', level: 3 },
  //       ],
  //     },
  //     {
  //       title: '0-2-1',
  //       key: '0-2-1',
  //       level: 2,
  //       children: [
  //         { title: '0-2-1-0', key: '0-2-1-0', level: 3 },
  //         { title: '0-2-1-1', key: '0-2-1-1', level: 3 },
  //         { title: '0-2-1-2', key: '0-2-1-2', level: 3 },
  //       ],
  //     },
  //     {
  //       title: '0-2-2',
  //       key: '0-2-2',
  //       level: 2,
  //     },
  //   ],
  // },
  // {
  //   title: '0-2',
  //   key: '0-2',
  //   level: 1,
  //   children: [
  //     {
  //       title: '0-2-0',
  //       key: '0-2-0',
  //       level: 2,
  //       children: [
  //         { title: '0-2-0-0', key: '0-2-0-0', level: 3 },
  //         { title: '0-2-0-1', key: '0-2-0-1', level: 3 },
  //         { title: '0-2-0-2', key: '0-2-0-2', level: 3 },
  //       ],
  //     },
  //     {
  //       title: '0-2-1',
  //       key: '0-2-1',
  //       level: 2,
  //       children: [
  //         { title: '0-2-1-0', key: '0-2-1-0', level: 3 },
  //         { title: '0-2-1-1', key: '0-2-1-1', level: 3 },
  //         { title: '0-2-1-2', key: '0-2-1-2', level: 3 },
  //       ],
  //     },
  //     {
  //       title: '0-2-2',
  //       key: '0-2-2',
  //       level: 2,
  //     },
  //   ],
  // },
  // {
  //   title: '0-2',
  //   key: '0-2',
  //   level: 1,
  //   children: [
  //     {
  //       title: '0-2-0',
  //       key: '0-2-0',
  //       level: 2,
  //       children: [
  //         { title: '0-2-0-0', key: '0-2-0-0', level: 3 },
  //         { title: '0-2-0-1', key: '0-2-0-1', level: 3 },
  //         { title: '0-2-0-2', key: '0-2-0-2', level: 3 },
  //       ],
  //     },
  //     {
  //       title: '0-2-1',
  //       key: '0-2-1',
  //       level: 2,
  //       children: [
  //         { title: '0-2-1-0', key: '0-2-1-0', level: 3 },
  //         { title: '0-2-1-1', key: '0-2-1-1', level: 3 },
  //         { title: '0-2-1-2', key: '0-2-1-2', level: 3 },
  //       ],
  //     },
  //     {
  //       title: '0-2-2',
  //       key: '0-2-2',
  //       level: 2,
  //     },
  //   ],
  // },
];
