import React, { useRef, useState } from 'react';
import { Row, Col, Tree } from 'antd';
import { treeDataList } from '../data';
import CustomTree from '@/components/CustomTree';

const { TreeNode } = Tree;
const { CTreeNode } = CustomTree;

const CheckboxList = props => {
  const [expandedKeys, setExpandedKeys] = useState([]);
  const [treeData, setTreeData] = useState(treeDataList);
  const refTreeNode = useRef();

  const renderTreeNodes = data =>
    data.map(item => {
      if (item.children) {
        return (
          <CTreeNode ref={refTreeNode} label={item.title} key={item.key} dataRef={item}>
            {renderTreeNodes(item.children)}
          </CTreeNode>
        );
      }
      return <CTreeNode ref={refTreeNode} key={item.key} label={item.title} {...item} />;
    });

  const updateTreeData = (list, key, children) =>
    list.map(node => {
      if (node.key === key) {
        return {
          ...node,
          children,
        };
      }
      if (node.children) {
        return {
          ...node,
          children: updateTreeData(node.children, key, children),
        };
      }
      return node;
    });
  const onExpand = expandedKeysValue => {
    console.log('onExpand', expandedKeysValue);
    setExpandedKeys(expandedKeysValue);
  };
  const onLoadData = ({ key, children }) =>
    new Promise(resolve => {
      if (children) {
        resolve();
        return;
      }
      setTimeout(() => {
        setTreeData(origin =>
          updateTreeData(origin, key, [
            { title: 'Child Node', key: `${key}-0` },
            { title: 'Child Node', key: `${key}-1` },
          ]),
        );

        resolve();
      }, 1000);
    });

  return (
    // <CustomTree>
    //   <Row justify="space-between">
    //     {treeData && treeData.length && treeData.map(item =>
    //       <Col span={7}>
    //         <CTreeNode treeData={item} ref={refTreeNode} label={item.title}>
    //           {item.children && renderTreeNodes(item.children)}
    //         </CTreeNode>
    //       </Col>,
    //     )}
    //   </Row>
    // </CustomTree>
    <CustomTree treeData={treeData} />
  );
};

export default CheckboxList;
