/* eslint-disable no-unused-expressions */
import React, { useState, useLayoutEffect, useEffect, useRef } from 'react';
import { Row, Col } from 'antd';
import styles from './index.less';
import CTreeNode from './CTreeNode';
import { deepClone } from '@/utils/utils';

const CustomTree = props => {
  const [hideChildren, setHideChildern] = useState(false);
  const refNode = useRef();
  const [treeData, setTreeData] = useState([]);

  // const updateTreeData = (list, obj, isChecked) => {
  //   let checked = false;
  //   list.forEach(node => {
  //     if (node.key === obj.key) {
  //       checked = true;
  //       if (obj.children) {
  //         node.value = isChecked ? obj.children.map(item => item.key) : [];
  //       } else {
  //         node.value = isChecked ? [obj.key] : []
  //       }
  //     } else if (node.children) {
  //       const res = updateTreeData(node.children, obj, isChecked)
  //       if (res) {
  //         node.value ? node.value.push(obj.key) : (node.value = [obj.key]);
  //         checked = true;
  //       }
  //     }
  //   });
  //   return checked;
  // }
  const updateChildren = (list, isChecked) => {
    list.forEach(item => {
      item.indeterminate = isChecked;
      item.checked = isChecked;
      if (item.children) {
        item.value = isChecked ? item.children.map(c => c.key) : [];
        updateChildren(item.children, isChecked);
      } else {
        item.value = isChecked ? [item.key] : [];
      }
    });
  };

  const updateTreeData = (list, obj, isChecked) => {
    const json = {
      checked: false,
      key: obj.key,
    };
    let checked = false;
    list.forEach(node => {
      if (node.key === obj.key) {
        json.checked = isChecked;
        checked = isChecked;
        if (node.children) {
          node.value = isChecked ? node.children.map(item => item.key) : [];
          updateChildren(node.children, isChecked);
        } else {
          node.value = isChecked ? [obj.key] : [];
          node.checked = isChecked;
        }
      } else if (node.children) {
        json.checked = updateTreeData(node.children, obj, isChecked);
        // console.log('json.key :>> ', json.key);
        // if (json.checked) {
        //   node.value.push(json.key);
        //   json.key = node.key;
        // } else {
        //   const index = node.value.indexOf(json.key);
        //   index > -1 && node.value.splice(index, 1);
        // }
      }
      json.key = node.key;
    });
    return checked;
  };

  // const changeChecked = (list, obj, isChecked) => {
  //   list.forEach(node => {
  //     if (node.key === obj.key) {
  //       node.checked = isChecked;
  //     } else if (node.children) {
  //       changeChecked(node.children, obj, isChecked);
  //     }
  //   });
  // }

  const onChange = (obj, isChecked) => {
    // console.log('obj1 :>> ', obj);
    const datas = [...treeData];
    // changeChecked(datas, obj, isChecked)
    updateTreeData(datas, obj, isChecked);
    console.log('datas :>> ', datas);
    setTreeData(datas);
  };

  const getChecked = (parent, item) => {
    const res =
      parent.value &&
      (parent.value.indexOf(item.key) > -1 ||
        (item.value && item.value[0] === item.key) ||
        (parent.children && parent.value.length === parent.children.length));
    if (item.key === '0-0') {
      // console.log('item.value && item.value[0] === item.key :>> ', item.value && item.value[0] === item.key);
      // console.log('parent1, item2 :>> ', res, parent, item);
    }
    // res === undefined && console.log('res :>> ', parent, item);
    return res;
  };

  const renderTreeNodes = (data, parent) =>
    data &&
    data.map(item => {
      if (item.children) {
        return (
          <CTreeNode
            ref={refNode}
            label={item.title}
            onChange={onChange}
            checked={getChecked(parent, item)}
            key={item.key}
            treeData={item}
          >
            {renderTreeNodes(item.children, item)}
          </CTreeNode>
        );
      }
      return (
        <CTreeNode
          ref={refNode}
          label={item.title}
          onChange={onChange}
          checked={getChecked(parent, item)}
          key={item.key}
          treeData={item}
        />
      );
    });

  const handleMouseUp = e => {
    const isCur = e.path.some(item => item.id === 'my-custom-tree-box');
    if (isCur) {
      console.log('20001112 :>> ', 20001112);
    } else {
      console.log('3333 :>> ', 3333);
      refNode.current.onClose();
    }
  };

  useEffect(() => {
    window.addEventListener('mouseup', handleMouseUp, false);
    return () => {
      window.removeEventListener('mouseup', handleMouseUp, false);
    };
  }, []);

  const deepCloneArr = (arr = []) => {
    // console.log('arr :>> ', arr);
    arr.forEach(item => {
      item.value = [];
      if (item.children) {
        deepCloneArr(item.children);
      }
    });
  };

  useEffect(() => {
    const arr = deepClone(props.treeData || []);
    deepCloneArr(arr);
    setTreeData(arr);
  }, [props.treeData]);

  return (
    <div className={styles['tree-box']} id="my-custom-tree-box">
      <Row justify="space-between">
        {treeData.length &&
          treeData.map(item => (
            <Col span={7}>
              <CTreeNode
                ref={refNode}
                label={item.title}
                onChange={onChange}
                key={item.key}
                checked={getChecked(item, item)}
                treeData={item}
              >
                {item.children && renderTreeNodes(item.children, item)}
              </CTreeNode>
            </Col>
          ))}
      </Row>
    </div>
  );
};
CustomTree.CTreeNode = CTreeNode;

export default CustomTree;
