import React, { useState, useImperativeHandle, useRef, forwardRef, useEffect } from 'react';
import { Checkbox } from 'antd';
import { CaretRightOutlined, CaretDownOutlined } from '@ant-design/icons';
import styles from './index.less';

const CheckboxGroup = Checkbox.Group;

const CustomTree = forwardRef((props, ref) => {
  const [checked, setChecked] = useState(false);
  const [checkExpand, setCheckExpand] = useState(false);
  const refNode = useRef(null);

  const onChange = e => {
    console.log('props.treeData :>> ', props.treeData);
    props.onChange(
      {
        key: props.treeData.key,
        children: props.children,
      },
      !checked,
    );
    setChecked(!checked);
  };

  const onClose = () => {
    setCheckExpand(false);
  };

  useImperativeHandle(ref, () => ({
    onClose,
  }));

  // useEffect(() => {
  //   // console.log('props.hideChildren :>> ', props.hideChildren);
  //   // setCheckExpand(false);
  //   console.log('props.treeData :>> ', props.treeData);
  // }, [])

  return (
    <div className={styles['ccheck-box']} ref={refNode}>
      {props.children && (
        <div className={styles['ccheck-box--expand']} onClick={() => setCheckExpand(!checkExpand)}>
          {checkExpand ? <CaretDownOutlined /> : <CaretRightOutlined />}
        </div>
      )}
      <Checkbox
        onChange={onChange}
        indeterminate={
          !props.checked && props.treeData.value ? props.treeData.value.length > 0 : false
        }
        checked={props.checked}
      >
        {props.label}
        {`${props.checked}`}
      </Checkbox>
      {checkExpand && <div className={styles['ccheck-box--childrens']}>{props.children}</div>}
    </div>
  );
});

export default CustomTree;
