import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Modal, Input, Select, Cascader, Tag, notification, Tree, Col, Row } from 'antd';
import React, { useState, useEffect } from 'react';
import { el } from 'date-fns/locale';
import { areaList, getAddTemplate, forbiddenAddress } from '../services';
import { treeDataList } from '../data';
import CheckboxList from './CheckboxList';

const { Option } = Select;
const { TreeNode } = Tree;

const AddAreaModal = props => {
  const {
    visible,
    form: { getFieldDecorator, validateFields, resetFields, setFieldsValue },
    templateData,
  } = props;
  const [addList, setAddList] = useState([]);
  const [selectedList, setSelectedList] = useState([]);
  const [selected, setSelect] = useState([]);
  const [expandedKeys, setExpandedKeys] = useState([]);
  const [treeData, setTreeData] = useState(treeDataList);

  const formItemLayout = {
    labelCol: {
      span: 6,
    },
    wrapperCol: {
      span: 16,
    },
  };
  const loadProvice = async () => {
    const data = await areaList();
    if (data && data.length) {
      const arr = data.map(item => ({
        title: item.addrName,
        key: item.addrId,
        level: item.addrLevel,
        children: [],
      }));
      setTreeData(arr);
    }
  };

  const onCancel = () => {
    setSelectedList([]);
    resetFields();
    setSelect([]);
    props.onSubmit();
  };
  const handleOk = async () => {
    const { length } = selectedList;
    // if (!selectedList.length) {
    //   notification.error({ message: '请选择限制区域！' });
    //   return;
    // }
    validateFields(async (error, fieldsValue) => {
      const newData = [];
      selectedList.map(itemData =>
        newData.push({
          addressId: itemData.addressId,
          addressLevel: itemData.addressLevel,
          addressName: itemData.addressName,
        }),
      );
      if (!error) {
        if (props.templateData.status) {
          const data = await forbiddenAddress({
            templateId: props.templateData.id,
            templateName: fieldsValue.templateName,
            areaList: newData,
          });
          if (data.businessCode === '0000') {
            notification.success({ message: '编辑成功！' });
            onCancel();
          }
        } else {
          const data = await getAddTemplate({
            templateName: fieldsValue.templateName,
            areaList: newData,
          });
          if (data.businessCode === '0000') {
            notification.success({ message: '添加成功！' });
            onCancel();
          }
        }
      }
    });
  };
  // 判断是否重复
  const getChilds = select => {
    const reslutData = selectedList.filter(
      item =>
        !select.addressName.includes(item.addressName) &&
        !item.addressName.includes(select.addressName),
    );
    reslutData.push(select);
    return reslutData;
  };

  const renderTreeNodes = data =>
    data.map(item => {
      if (item.children) {
        return (
          <TreeNode title={item.name} key={item.key} dataRef={item}>
            {renderTreeNodes(item.children)}
          </TreeNode>
        );
      }
      return <TreeNode key={item.key} {...item} />;
    });
  const updateTreeData = (list, key, children) =>
    list.map(node => {
      if (node.key === key) {
        return {
          ...node,
          children,
        };
      }
      if (node.children) {
        return {
          ...node,
          children: updateTreeData(node.children, key, children),
        };
      }
      return node;
    });
  const onExpand = expandedKeysValue => {
    console.log('onExpand', expandedKeysValue);
    setExpandedKeys(expandedKeysValue);
  };
  const onLoadData = ({ key, children }) =>
    new Promise(resolve => {
      if (children) {
        resolve();
        return;
      }
      setTimeout(() => {
        setTreeData(origin =>
          updateTreeData(origin, key, [
            { title: 'Child Node', key: `${key}-0` },
            { title: 'Child Node', key: `${key}-1` },
          ]),
        );
        resolve();
      }, 1000);
    });
  useEffect(() => {
    // getAreaList();
    if (props.templateData) {
      setSelectedList(props.templateData.list);
    }
  }, [props.templateData]);

  // useEffect(() => {
  //   props.visible && loadProvice();
  // }, [props.visible])

  return (
    <Modal
      title={props.templateData.status ? '编辑限制区域配送模板' : '添加限制区域配送模板'}
      maskClosable={false}
      visible={visible}
      width="1000px"
      onCancel={() => onCancel()}
      onOk={() => handleOk()}
    >
      <Form {...formItemLayout}>
        <Form.Item label="模板名称">
          {getFieldDecorator('templateName', {
            rules: [{ required: true, message: '请输入模板名称!' }],
            initialValue: templateData.templateName,
          })(<Input placeholder="请填写模板名称" maxLength={20} />)}
        </Form.Item>
        <Form.Item label="限制配送区域">{getFieldDecorator('name')(<CheckboxList />)}</Form.Item>
      </Form>
    </Modal>
  );
};

export default Form.create()(AddAreaModal);
