import React, { createRef, useState } from 'react';
import { Modal, Button, Tabs, Upload, notification, Icon } from 'antd';
import styles from '../style.less';
import { uploadFile } from '../service';
import UploadC from '../../components/upload';

const { Dragger } = Upload;

const { TabPane } = Tabs;
export default props => {
  const { visible, settlementNo } = props;
  const [tabValue, setTabValue] = useState('1');
  const picUpload = createRef();
  const uploadProps = {
    name: 'file',
    async customRequest(info) {
      const result = await uploadFile(info.file, settlementNo);
      if (result.businessCode === '0000') {
        notification.success({ message: '导入成功' });
      }
    },
    accept: '.xlsx',
    showUploadList: false,
  };
  const uploadFn = () => {
    // 上传图片的接口
  };
  const changeTab = tabV => {
    setTabValue(tabV);
  };
  return (
    <Modal title="上传发票" visible={visible} footer={null} onCancel={props.onCancel} width="700px">
      <Tabs defaultActiveKey="1" className={styles.tab} onChange={changeTab} activeKey={tabValue}>
        <TabPane tab="上传凭证" key="1">
          <UploadC ref={picUpload} accept=".png,.jpg" />
        </TabPane>
        <TabPane tab="上传附件" key="2">
          <Dragger {...uploadProps}>
            <p>
              <Icon type="upload" />
            </p>
            <p>点击上传附件</p>
          </Dragger>
        </TabPane>
      </Tabs>
      {tabValue === '1' && (
        <Button type="primary" onClick={uploadFn} className={styles.logBtn}>
          确定上传
        </Button>
      )}
      {/* <Button type="primary" onClick={props.onCancel}>
        关闭
      </Button> */}
    </Modal>
  );
};
