import React, { useState } from 'react';
import ProTable from '@ant-design/pro-table';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
// import { FormInstance } from 'antd/lib/form';
import Detail from '../components/detail';
import ImgModal from '../components/imgModal';
import styles from './styles.less';
import { columns } from './staticdata';
import { query, getDetail } from './services';

const Appeal = () => {
  // const protable = useRef();
  // const ref = useRef(FormInstance);
  const [detailModal, changeDetailModal] = useState(false);
  const [imgModal, changeImgModal] = useState(false);
  const [selectedRow, getRow] = useState({});
  const [imgData, getImgData] = useState([]);
  const [imgTitle, changeImgTitle] = useState('');

  const audit = async row => {
    console.log('selected-row', row);
  };
  const openDetail = async row => {
    const detailData = await getDetail({ appealNo: row.appealNo });
    changeDetailModal(true);
    getRow(detailData);
  };
  const openImgModal = imgList => {
    // const list = ['https://www.baidu.com/img/flexible/logo/pc/result@2.png'];
    getImgData(imgList);
    // getImgData(list);
    changeImgModal(true);
    changeImgTitle('查看图片');
  };
  const closeModal = params => {
    if (params === 'Detail') {
      changeDetailModal(false);
      return;
    }
    changeImgModal(false);
  };
  const res = {
    audit,
    openDetail,
    openImgModal,
  };

  return (
    <PageHeaderWrapper>
      <ProTable
        search={{
          collapsed: false,
          collapseRender: () => null,
        }}
        columns={columns(res)}
        request={params => query({ ...params })}
        rowKey="appealNo"
        expandIconColumnIndex={10}
        key="appealNo"
        bordered
        className={styles.table}
        toolBarRender={false}
        scroll={{ x: '100%' }}
      />
      <Detail
        data={selectedRow}
        modalVisible={detailModal}
        onCancel={() => closeModal('Detail')}
      ></Detail>
      <ImgModal
        imgData={imgData}
        modalVisible={imgModal}
        title={imgTitle}
        onCancel={() => closeModal('imgModal')}
      ></ImgModal>
    </PageHeaderWrapper>
  );
};
export default Appeal;
