import React from 'react';
import { Modal, Form, Select, Input, notification } from 'antd';
import { updateStatus } from '../services';

const FormItem = Form.Item;
const { Option } = Select;
const layout = {
  labelCol: { span: 6 },
  wrapperCol: { span: 16 },
};
const valueEnum = [
  {
    status: 1,
    text: '平',
  },
  {
    status: 2,
    text: '不平',
  },
];

const StatusForm = props => {
  const { visible, formData } = props;
  const { getFieldDecorator } = props.form;

  const resetForm = () => {
    props.form.resetFields();
  };

  const onCancel = () => {
    props.onClose();
    resetForm();
  };
  const handleSubmit = () => {
    props.form.validateFields(async (err, fieldsValue) => {
      if (err) return;
      const params = {
        ...fieldsValue,
        id: formData.id,
      };
      const businessCode = await updateStatus(params);
      if (businessCode === '0000') {
        notification.success({ message: '操作成功' });
        resetForm();
        props.onClose('success');
      }
    });
  };

  return (
    <Modal title="对账手动补齐" visible={visible} onCancel={() => onCancel()} onOk={handleSubmit}>
      <Form {...layout} name="formData">
        <FormItem label="状态">
          {getFieldDecorator('status', {
            initialValue: formData.status,
            rules: [
              {
                required: true,
                message: '请选择状态!',
              },
            ],
          })(
            <Select showSearch placeholder="">
              {valueEnum.map(item => (
                <Option value={item.status} key={item.status}>
                  {item.text}
                </Option>
              ))}
            </Select>,
          )}
        </FormItem>
        <FormItem label="备注">
          {getFieldDecorator('remarks', {
            initialValue: formData.remarks,
          })(<Input />)}
        </FormItem>
      </Form>
    </Modal>
  );
};

export default Form.create()(StatusForm);
