import React from 'react';
import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Modal, Input, Cascader, notification, InputNumber } from 'antd';
import { shopAudit } from '../services';

const FormItem = Form.Item;
const { TextArea } = Input;
const AuditModal = props => {
  const {
    visible,
    onCancel,
    form: { getFieldDecorator, getFieldValue, validateFields, resetFields },
    formData = {},
  } = props;

  const handleCancel = isSuccess => {
    resetFields();
    onCancel(isSuccess);
  };
  const treeData = [
    {
      label: '同意',
      value: 1,
    },
    {
      label: '不同意',
      value: 2,
      children: [
        {
          label: '商品与出售商品不符',
          value: 1,
        },
        {
          label: '影响二次销售',
          value: 2,
        },
        {
          label: '未提供商品照片,需要上传照片',
          value: 4,
        },
        {
          label: '快递正在配送中',
          value: 5,
        },
        {
          label: '订单已经取消',
          value: 6,
        },
        {
          label: '商品已超过售后期',
          value: 7,
        },
        {
          label: '其他',
          value: 3,
        },
      ],
    },
  ];
  const handleOk = () => {
    validateFields(async (error, fieldsValue) => {
      if (!error) {
        const { auditResult } = fieldsValue;
        const data = await shopAudit({
          ...fieldsValue,
          refuseCode: auditResult?.[1],
          auditResult: auditResult?.[0],
          serviceNo: formData?.serviceNo,
        });
        if (data.businessCode === '0000') {
          notification.success({ message: '审核成功' });
          handleCancel(true);
        }
      }
    });
  };

  const layout = {
    labelCol: { span: 6 },
    wrapperCol: { span: 16 },
  };
  const auditResult = getFieldValue('auditResult');
  const isAgree = () => auditResult?.[0] === 1;
  const isRefuse = () => auditResult && auditResult[0] !== 1;
  return (
    <Modal
      title="售后操作确认"
      visible={visible}
      onOk={() => handleOk()}
      onCancel={() => handleCancel()}
    >
      <Form {...layout} name="formData">
        <FormItem label="审核结果">
          {getFieldDecorator('auditResult')(
            <Cascader
              allowClear
              showSearch
              style={{ width: '315px' }}
              dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
              options={treeData}
              placeholder="请选择"
            />,
          )}
        </FormItem>
        {isAgree() && (
          <div>
            <FormItem label="退货地址">
              {getFieldDecorator('receiveAddress', {
                initialValue: formData.address,
                rules: [
                  {
                    required: true,
                    message: '请填写退货地址!',
                  },
                  {
                    message: '格式有误，请填写正确的退货地址!',
                    pattern: /[a-zA-Z0-9_\u4e00-\u9fa5]/g,
                  },
                ],
              })(<Input placeholder="最多输入50个字符" maxLength="50" allowClear />)}
            </FormItem>
            <FormItem label="收件人">
              {getFieldDecorator('receiverName', {
                initialValue: formData.name,
                rules: [
                  {
                    required: true,
                    message: '请填写收件人!',
                  },
                  {
                    message: '格式有误，请输入中英文、数字!',
                    pattern: /^[A-Za-z0-9\u4e00-\u9fa5]+$/,
                  },
                ],
              })(<Input placeholder="最多输入25个字符" maxLength="25" allowClear />)}
            </FormItem>
            <FormItem label="手机号码">
              {getFieldDecorator('receiverPhone', {
                initialValue: formData.phone,
                rules: [
                  // {
                  //   pattern: new RegExp(/^1[3456789]\d{9}$/, 'g'),
                  //   message: '手机号码格式不正确!',
                  // },
                  {
                    pattern: new RegExp(/^[0-9]*$/),
                    message: '手机号码格式不正确!',
                  },
                  {
                    required: true,
                    message: '请填写手机号码!',
                  },
                ],
              })(<Input placeholder="请填写手机号码" maxLength="11" allowClear />)}
            </FormItem>
          </div>
        )}
        {isRefuse() && auditResult[1] === 3 && (
          <FormItem label="拒绝原因">
            {getFieldDecorator('refuseDesc', {
              initialValue: formData.refuseDesc,
              rules: [
                {
                  required: true,
                  message: '请填写拒绝原因!',
                },
              ],
            })(
              <TextArea
                placeholder="请填写拒绝原因"
                allowClear
                autoSize={{ minRows: 3, maxRows: 6 }}
              />,
            )}
          </FormItem>
        )}
        {isRefuse() && auditResult[1] !== 3 && (
          <FormItem label="补充说明">
            {getFieldDecorator('refuseDesc', {
              initialValue: formData.refuseDesc,
              rules: [
                {
                  message: '请填写补充说明!',
                },
              ],
            })(
              <TextArea
                placeholder="请填写补充说明"
                allowClear
                autoSize={{ minRows: 3, maxRows: 6 }}
              />,
            )}
          </FormItem>
        )}
      </Form>
    </Modal>
  );
};

export default Form.create()(AuditModal);
