export default {
  get(key) {
    let result = localStorage.getItem(key);
    try {
      result = JSON.parse(result);
    } catch {
      console.log(); // eslint-disable-line no-console
    }
    return result;
  },
  set(key, value) {
    const { toString } = Object.prototype;
    if (toString.call(value) === '[object Array]' || toString.call(value) === '[object Object]') {
      value = JSON.stringify(value); // eslint-disable-line no-param-reassign
    }
    return localStorage.setItem(key, value);
  },
  remove(key) {
    return localStorage.removeItem(key);
  },
  clear() {
    return localStorage.clear();
  },
};
