import React, { useState, useEffect, forwardRef, useImperativeHandle } from 'react';
import { Modal, Table } from 'antd';
// import { queryOrderDetail } from '../../service';
import { COUPON_CODE_STATUS } from '../../const';
import style from './index.less';

const DetailModal = (props, ref) => {
  const [visible, setVisible] = useState(false);

  const modalProps = {
    visible,
    width: '1000px',
    title: '订单详情',
    footer: null,
    onCancel: () => {
      setVisible(false);
    },
  };

  // const getDetail = async orderNo => {
  //   const params = {
  //     orderNo,
  //   };
  //   const res = await queryOrderDetail(params);
  //   console.log(res);
  // };

  /** @module 基本信息 */
  const [baseInfo, setBaseInfo] = useState({});

  /** @module 商品table */
  const [goodData, setGoodData] = useState([]);
  const goodColumns = [
    {
      title: '商品',
      dataIndex: 'spuName',
      width: 350,
      render: (value, record) => {
        const { primaryImage, skuSpec, spuId } = record;
        return (
          <div className={style['sku-info']}>
            <img src={primaryImage} width="50px" height="50px" alt="" />
            <div className={style['sku-info__box']}>
              <p className={style['sku-info__box--name']}>{value}</p>
              {/* <p className={style['sku-info__box--spec']}>规格：{skuSpec}</p>
              <p className={style['sku-info__box--id']}>商品id: {spuId}</p> */}
            </div>
          </div>
        );
      },
    },
    {
      title: '单价（元）',
      dataIndex: 'supplyPrice',
      width: 150,
    },
    {
      title: '数量',
      dataIndex: 'count',
      width: 100,
    },
    {
      title: '小计',
      dataIndex: 'subTotal',
      width: 150,
      render: (value, record) => {
        const { supplyPrice, count } = record;
        return (supplyPrice * count).toFixed(2);
      },
    },
    {
      title: '商品备注',
      dataIndex: 'remark',
      width: 150,
    },
    {
      title: '售后状态',
      width: 150,
      render: row => {
        if (row.afterServiceStatusDesc) {
          return row.afterServiceStatusDesc;
        }
        if (row.afterSaleVos && row.afterSaleVos.length) {
          return row.afterSaleVos[0].afterServiceStatusDesc;
        }
        return '-';
      },
    },
  ];

  /** @module 券码 */
  const [couponData, setCouponData] = useState([]);
  const couponColumns = [
    {
      title: '券码',
      width: 150,
      render: (value, record, index) => `券码${index + 1}`,
    },
    {
      title: '有效期',
      dataIndex: 'useStartTime',
      width: 350,
      render: (value, record) => {
        const { useEndTime } = record;
        return `${value} - ${useEndTime}`;
      },
    },
    {
      title: '核销时间',
      dataIndex: 'useTime',
      width: 200,
      render: value => value || '-',
    },
    {
      title: '核销人',
      dataIndex: 'usedByShopName',
      width: 150,
      render: value => value || '-',
    },
    {
      title: '状态',
      dataIndex: 'codeStatus',
      width: 150,
      render: value => COUPON_CODE_STATUS[value],
    },
  ];

  const open = record => {
    console.log(record);
    setVisible(true);
    const {
      skuVos,
      couponCodeVos,
      receiverName,
      receiverMobile,
      fullAddress,
      orderNoStr,
      orderTime,
      payTime,
    } = record;

    setGoodData(skuVos);
    setCouponData(couponCodeVos);
    setBaseInfo({
      receiverName,
      receiverMobile,
      fullAddress,
      orderNo: orderNoStr,
      orderTime,
      payTime,
    });

    // getDetail(orderNo);
  };

  useImperativeHandle(ref, () => ({
    open,
  }));

  return (
    <Modal {...modalProps}>
      <div className={style['order-info']}>
        <div className={style['order-info--item']}>
          <div className={style['order-info--item__title']}>收货人信息</div>
          <ul className={style['order-info--item__ul']}>
            <li>姓名：{baseInfo.receiverName}</li>
            <li>手机号：{baseInfo.receiverMobile}</li>
            <li>地址：{baseInfo.fullAddress}</li>
          </ul>
        </div>
        <div className={style['order-info--item']}>
          <div className={style['order-info--item__title']}>订单信息</div>
          <ul className={style['order-info--item__ul']}>
            <li>订单号：{baseInfo.orderNo}</li>
            <li>下单时间：{baseInfo.orderTime}</li>
            <li>付款时间：{baseInfo.payTime}</li>
          </ul>
        </div>
      </div>

      {/* 商品 */}
      <div className={style['good-table']}>
        <Table
          pagination={false}
          rowKey="orderSkuId"
          bordered
          columns={goodColumns}
          dataSource={goodData}
        ></Table>
      </div>
      {/* 券码 */}
      <div className={style['coupon-table']}>
        <Table pagination={false} bordered columns={couponColumns} dataSource={couponData}></Table>
      </div>
    </Modal>
  );
};

export default forwardRef(DetailModal);
