// Change theme plugin
// eslint-disable-next-line eslint-comments/abdeils - enable - pair;

/* eslint-disable import/no-extraneous-dependencies */
import generate from '@ant-design/colors/lib/generate';
import webpack from 'webpack';
const SentryPlugin = require('@qg/sentry-webpack-plugin');
const SentryConfig = require('../.sentryclirc');

export default config => {
  if (process.env.NODE_ENV === 'production') {
    config.plugin('sentry-webpack-plugin').use(SentryPlugin, [SentryConfig]);
  }
  if (process.env.SENTRY_ENV === 'prod') {
    config.plugin('source-map-dev-tool-plugin').use(webpack.SourceMapDevToolPlugin, [
      {
        exclude: /(antdesigns|vendors|mapvgl).*/, // 以下文件排除不生成
        filename: '[file].map[query]', // 指定map文件名称
      },
    ]);
  }

  config.optimization // share the same chunks across different modules
    .splitChunks({
      chunks: 'all', //async异步代码分割 initial同步代码分割 all同步异步分割都开启
      automaticNameDelimiter: '.',
      name: 'common',
      minSize: 30000, // 引入的文件大于30kb才进行分割
      minChunks: 1, // 模块至少使用次数
      cacheGroups: {
        // 分离antd系代码
        antdesigns: {
          name: 'antdesigns',
          chunks: 'all',
          test: /[\\/]node_modules[\\/](@antv|antd|@ant-design|rc-*|[\\@]ctrl[\\/]tinycolor|tinycolor2)/,
          priority: 10,
        },
        // 分离公共类库
        vendors: {
          name: 'vendors',
          chunks: 'all',
          test: /([\\/]node_modules[\\/](lodash|moment|react|dva|postcss|mapbox-gl|date-fns|sentry|react-sortablejs|sortablejs))|([\\/]src[\\/]utils[\\/]qiniu\.min\.js)/,
          priority: 10,
          enforce: true,
        },
        // 分离geo库
        mapvgl: {
          name: 'mapvgl',
          chunks: 'all',
          test: /[\\/]node_modules[\\/](mapvgl|react-bmapgl|react-amap)/,
          priority: 11,
        },
      },
    });
};

const getAntdSerials = color => {
  const lightNum = 9;
  const devide10 = 10; // 淡化（即less的tint）

  const lightens = new Array(lightNum).fill(undefined).map((_, i) => {
    return ThemeColorReplacer.varyColor.lighten(color, i / devide10);
  });
  const colorPalettes = generate(color);
  const rgb = ThemeColorReplacer.varyColor.toNum3(color.replace('#', '')).join(',');
  return lightens.concat(colorPalettes).concat(rgb);
};
