import React, { useRef, useState } from 'react';
import { Tabs, notification, Form, Modal } from 'antd';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import { AFTER_SALE_ORDER } from '@/../config/permission.config';
import { connect } from 'dva';
import { FormSearch } from '@/components/FormSearch';
import moment from 'moment';
import AuditModal from './components/auditModal';
import DetailTable from './components/detailTable';
import ProofsModal from './components/proofsModal';
import AppealDetail from '@/pages/afterSale/components/detail';
import AfterLog from './components/AfterLog';

import { getColumns, getFormConfig } from './data.js';
import { getDetail } from '@/pages/afterSale/appeal/services';
import { searchList, logisticsIntercept, orderDetail, getOpLog, auditInfoApi } from './services';

import styles from './index.less';

const { TabPane } = Tabs;
const { confirm } = Modal;

const AfterSale = props => {
  const { permissions } = props;
  const canEditable = permissions[AFTER_SALE_ORDER.EDITABLE];
  const actionRef = useRef();
  const formRef = useRef();
  const [tableParams, setTableParams] = useState({});
  const [appealDetailModal, setAppealDetailModal] = useState(false);
  const [selectedRow, setSelectedRow] = useState({});
  // 申诉
  const [proofsData, setProofsData] = useState([]);
  const [proofsVisible, setProofsVisible] = useState(false);

  // 详情
  const [detailVisible, setDetailVisible] = useState(false);
  const [detailInfo, setDetailInfo] = useState([]);
  //  售后操作记录
  const [afterVisible, setAfterVisible] = useState(false);
  const [afterList, setAfterList] = useState([]);

  // 审核
  const [visible, setVisible] = useState(false);
  const [auditInfo, setAuditInfo] = useState({});

  // 关闭modal
  const closeModal = isReload => {
    if (isReload === true) {
      // eslint-disable-next-line no-unused-expressions
      actionRef.current?.reload?.();
    }
    setVisible(false);
    setDetailVisible(false);
    setProofsVisible(false);
    setAppealDetailModal(false);
    setAfterVisible(false);
  };

  // 查看申诉详情
  const viewAppeal = async r => {
    const detailData = await getDetail({ appealNo: r.appealNo });
    setAppealDetailModal(true);
    setSelectedRow(detailData);
  };

  // 查看凭证
  const viewProofs = proofs => {
    if (!proofs) {
      notification.warning({ message: '该订单没有凭证' });
      return;
    }
    const list = proofs.replace(/(\uff1b|\uff0c|\u003b)/g, ',').split(',');
    setProofsData(list);
    setProofsVisible(true);
  };

  // 审核
  const openAudit = async ({ serviceNo, serviceType }) => {
    const data = await auditInfoApi({ serviceNo });
    setAuditInfo({ ...data?.data, serviceNo, serviceType });
    setVisible(true);
  };

  // 物流拦截
  const openLogistics = r => {
    confirm({
      title: '温馨提示',
      okText: '确认拦截',
      cancelText: '取消拦截',
      content: (
        <div>
          请48小时内自行联系物流公司进行物流拦截，系统监测拦截成功后
          <span className={styles.redTipBold}>自动同意</span>退款
        </div>
      ),
      async onOk() {
        const data = await logisticsIntercept({ serviceNo: r.serviceNo });
        if (data.businessCode === '0000') {
          notification.success({ message: '拦截成功' });
          actionRef.current.reload();
        } else {
          notification.error({ message: data.msg || '拦截失败' });
        }
      },
      onCancel() {
        console.log('Cancel');
      },
    });
  };

  //  查看
  const viewDetail = async ({ serviceNo }) => {
    const res = await orderDetail({ serviceNo });
    const data = res.data || [];
    setDetailInfo(data);
    setDetailVisible(true);
  };

  // 查看售后操作日志
  const viewLog = async r => {
    const data = await getOpLog(r.serviceNo);
    if (data?.data?.length) {
      setAfterList(data.data);
      setAfterVisible(true);
    }
  };

  const tabChange = e => {
    console.log(e);
  };

  const [form] = Form.useForm();
  const formConfig = getFormConfig({
    setTableParams,
  });
  const FormSearchProps = {
    form,
    initialValues: {},
    formOptions: {},
    ...formConfig,
  };
  const columns = getColumns({
    openAudit,
    viewAppeal,
    viewProofs,
    openLogistics,
    viewDetail,
    viewLog,
    canEditable,
  });

  // 表格属性
  const tableProps = {
    columns,
    params: tableParams,
    bordered: true,
    scroll: { x: '100%', y: 500 },
    rowKey: r => r.serviceNo,
    request: async params => {
      console.log(params);
      console.log('搜索', params);
      const { current: page, pageSize: size } = params;
      const startDate = params.startDate ? moment(params.startDate).format('YYYY-MM-DD') : '';
      const endDate = params.endDate ? moment(params.endDate).format('YYYY-MM-DD') : '';
      const requestParams = {
        page,
        size,
        queryStatus: 1,
        ...params,
        startDate,
        endDate,
      };
      const res = await searchList(requestParams);
      const { records = [], total } = res.data;
      return {
        data: records,
        total,
      };
    },
    toolBarRender: null,
  };
  return (
    <PageHeaderWrapper>
      <FormSearch {...FormSearchProps} />
      <div className={styles['tab-box']}>
        <Tabs onChange={tabChange} size="large" tabBarStyle={{ padding: '0 30px' }}>
          <TabPane key="" tab="全部"></TabPane>
          <TabPane key={1} tab="仅退款（未发货）"></TabPane>
          <TabPane key={2} tab="待审核0"></TabPane>
          <TabPane key={3} tab="仅退款待审核8"></TabPane>
          <TabPane key={4} tab="退货退款待审核0"></TabPane>
          <TabPane key={5} tab="退货入库待审核0"></TabPane>
          <TabPane key={6} tab="已完成0"></TabPane>
        </Tabs>
      </div>
      <ProTable
        {...tableProps}
        actionRef={actionRef}
        formRef={formRef}
        search={false}
        toolBarRender={false}
      />

      <AuditModal visible={visible} onCancel={closeModal} formData={auditInfo} />
      <DetailTable visible={detailVisible} onCancel={closeModal} dataSource={detailInfo} />
      <ProofsModal visible={proofsVisible} onCancel={closeModal} data={proofsData} />
      <AppealDetail
        data={selectedRow}
        modalVisible={appealDetailModal}
        onCancel={closeModal}
      ></AppealDetail>
      <AfterLog visible={afterVisible} onCancel={closeModal} data={afterList} />
    </PageHeaderWrapper>
  );
};

export default connect(({ menu }) => ({
  permissions: menu.permissions,
}))(AfterSale);
