import { Tag, Badge, Statistic, Button } from 'antd';
import React from 'react';
import moment from 'moment';

import { SEARCH_TYPE } from '@/components/FormSearch';

const { Countdown } = Statistic;

// 商户审核中/商户审核拒绝/待填写退货物流信息/待退货入库/退货拒收/退款成功/用户撤销”
// 仅退款（未发货）/仅退款/退货退款，新增【仅退款（未发货）】即取消订单待审核

// 售后类型
const AFTER_TYPE = [
  {
    value: '1',
    name: '商户审核中',
  },
  {
    value: '2',
    name: '商户审核拒绝',
  },
  {
    value: '3',
    name: '待填写退货物流信息',
  },
  {
    value: '4',
    name: '待退货入库',
  },
  {
    value: '5',
    name: '退货拒收',
  },
  {
    value: '5',
    name: '退款成功',
  },
  {
    value: '6',
    name: '用户撤销”',
  },
];

// 售后状态
const AFTER_STATUS = [
  {
    value: '1',
    name: '仅退款（未发货）',
  },
  {
    value: '1',
    name: '仅退款',
  },
  {
    value: '1',
    name: '退货退款',
  },
];

export const getFormConfig = (props = {}) => {
  const { setTableParams } = props;
  return {
    formConfig: [
      {
        type: SEARCH_TYPE.INPUT,
        label: '订单ID',
        bindKey: 'orderNo',
        column: 5,
      },
      {
        type: SEARCH_TYPE.INPUT,
        label: '售后单ID',
        bindKey: 'serviceNo',
        column: 5,
      },
      {
        type: SEARCH_TYPE.SELECT,
        label: '售后状态',
        column: 5,
        bindKey: 'dealStatus',
        options: AFTER_STATUS,
      },
      {
        type: SEARCH_TYPE.SELECT,
        label: '售后类型',
        column: 5,
        bindKey: 'type',
        options: AFTER_TYPE,
      },
      {
        type: SEARCH_TYPE.INPUT,
        label: '收货人姓名',
        column: 5,
        bindKey: 'receiverName',
      },
      {
        type: SEARCH_TYPE.INPUT,
        label: '收货人手机号',
        column: 5,
        bindKey: 'receiverPhone',
      },
      {
        type: SEARCH_TYPE.DATE_PICKER,
        label: '订单开始日期',
        column: 5,
        bindKey: 'startDate',
      },
      {
        type: SEARCH_TYPE.DATE_PICKER,
        label: '订单结束日期',
        column: 5,
        bindKey: 'endDate',
      },
    ],
    btnConfig: [
      {
        label: '筛选',
        clickType: 'submit',
        onClick: ({ type, params }) => {
          setTableParams(params);
        },
      },
      {
        label: '重置',
        type: '',
        clickType: 'reset',
        onClick: () => {
          setTableParams({});
        },
      },
    ],
  };
};

export const appealType = {
  1: '已申诉',
  0: '未申诉',
};

export const getColumns = props => {
  const {
    openAudit,
    viewAppeal,
    viewProofs,
    openLogistics,
    viewDetail,
    viewLog,
    canEditable,
  } = props;
  return [
    {
      title: '审核倒计时',
      dataIndex: 'serviceTime',
      key: 'serviceTime',
      hideInSearch: true,
      width: 150,
      render: (val, record) => {
        const serviceTime = moment(record.approvalEndTime).valueOf();
        return (
          <Countdown
            format="HH时mm分ss秒"
            value={serviceTime}
            valueStyle={{ color: 'red', fontSize: '14px' }}
          />
        );
      },
    },
    {
      title: '售后状态',
      dataIndex: 'serviceStatus',
      hideInSearch: true,
      width: 120,
    },
    {
      title: '售后类型',
      dataIndex: 'serviceType',
      hideInSearch: true,
      width: 120,
      render: serviceType => {
        if (+serviceType === 1) {
          return <span style={{ color: '#ff1616' }}>仅退款</span>;
        }
        return <span>退货退款</span>;
      },
    },
    {
      title: '订单ID',
      dataIndex: 'orderNo',
      hideInTable: true,
      width: 200,
    },
    {
      title: '售后单ID',
      dataIndex: 'serviceNo',
      width: 300,
      render: (serviceNo, r) => (
        <div>
          {r.timeout ? <Tag color="red">{serviceNo}</Tag> : serviceNo}
          {<Badge count={r.reminderFlag ? '催' : ''} size="default" />}
        </div>
      ),
    },
    {
      title: '订单ID',
      dataIndex: 'orderNo',
      hideInSearch: true,
      width: 300,
    },
    {
      title: '售后状态',
      dataIndex: 'dealStatus',
      hideInTable: true,
      valueEnum: {
        0: '待审核',
        10: '三方审核中',
        11: '三方审核通过',
        12: '三方审核拒绝',
        13: '客服审核通过',
        14: '商户审核中',
        15: '商户审核通过',
        16: '商户审核拒绝',
        20: '审核拒绝',
        21: '申诉中',
        30: '待填写退货物流信息',
        40: '待退货入库',
        50: '退货拒收',
        60: '待退款',
        61: '退货处理中',
        70: '售后成功',
        99: '用户取消',
      },
      width: 100,
    },
    {
      title: '售后类型',
      dataIndex: 'type',
      hideInTable: true,
      width: 120,
      valueEnum: {
        1: '仅退款',
        2: '退货退款',
      },
    },

    {
      title: '收货人姓名',
      dataIndex: 'receiverName',
      width: 200,
    },
    {
      title: '收货人手机号',
      dataIndex: 'receiverPhone',
      width: 200,
    },
    {
      title: '收货人地址',
      dataIndex: 'receiveAddress',
      width: 200,
      hideInSearch: true,
    },
    {
      title: '订单开始时间',
      width: 120,
      dataIndex: 'startDate',
      key: 'startDate',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: '订单结束时间',
      width: 120,
      dataIndex: 'endDate',
      key: 'endDate',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: '售后原因',
      dataIndex: 'serviceReason',
      hideInSearch: true,
      width: 200,
    },
    {
      title: '售后发生时间',
      dataIndex: 'serviceTime',
      hideInSearch: true,
      width: 200,
    },
    {
      title: '超时时间',
      dataIndex: 'overtime',
      hideInSearch: true,
      width: 200,
    },
    {
      title: '是否催办',
      dataIndex: 'reminderFlag',
      hideInSearch: true,
      width: 120,
      valueEnum: {
        true: '是',
        false: '否',
      },
    },
    {
      title: '是否同意售后',
      dataIndex: 'isAgree',
      hideInSearch: true,
      width: 120,
    },
    {
      title: '拒绝原因',
      dataIndex: 'refuseReason',
      hideInSearch: true,
      width: 200,
    },
    {
      title: '售后凭证',
      dataIndex: 'proofs',
      hideInSearch: true,
      width: 100,
      render: (val, r) => <a onClick={() => viewProofs(r.proofs)}>查看凭证</a>,
    },
    {
      title: '售后申诉',
      dataIndex: 'appealFlag',
      valueEnum: appealType,
      hideInSearch: true,
      width: 120,
      render: (appealFlag, r) => {
        if (appealFlag) {
          return <a onClick={() => viewAppeal(r)}>已申诉</a>;
        }
        return <div>未申诉</div>;
      },
    },
    {
      title: '操作',
      hideInSearch: true,
      dataIndex: 'action',
      width: 250,
      fixed: 'right',
      render: (val, r) => {
        const operations = [
          <Button key="link1" onClick={() => openAudit(r)} className="mr10 mt10" type="primary">
            审核
          </Button>,
          <Button
            disabled={r.serviceType !== 1 || (r.serviceType === 1 && r.intercept)}
            onClick={() => openLogistics(r)}
            className="mr10 mt10"
            type="primary"
          >
            物流拦截
          </Button>,
          <Button className="mr10 mt10" key="link" onClick={() => viewDetail(r)} type="primary">
            订单详情
          </Button>,
          <Button className="mr10 mt10" type="primary" onClick={() => viewLog(r)}>
            查看记录
          </Button>,
        ];

        // 不可编辑直接隐藏可操作按钮
        if (!canEditable) {
          return [operations[2], operations[3]];
        }

        // 服务订单删除物流拦截
        if (!['vip', 'self'].includes(r.supplierType)) {
          return [operations[0], operations[2], operations[3]];
        }
        return operations;
      },
    },
  ];
};
