import React, { useState, useEffect } from 'react';
import { Badge, notification } from 'antd';
import { CloseOutlined } from '@ant-design/icons';
import classNames from 'classnames';
import { connect } from 'dva';
import { apiGetBussinessMsgList } from '@/services/messageReminder';
import Empty from '../Empty';
import styles from './index.less';

import { CHANNEL_ID } from '@/utils/constants';

const Horn = props => {
  const { count, toggle, animationClass } = props;
  return (
    <div className={classNames(styles.horn, styles[animationClass])} onClick={toggle}>
      <Badge count={count}>
        <div className={styles['horn--num']}>消息提醒</div>
      </Badge>
    </div>
  );
};

const Message = props => {
  const { toggle, animationClass, messageData, openComplex, onMark } = props;

  const ReminderItem = args => {
    const { item } = args;
    const { orderNo, createdAt } = JSON.parse(item.sendContent || '{}');
    return (
      <div className={styles.item}>
        <div className={styles.info}>
          <span className={styles['order-number']}>{orderNo}</span>
          <span className={styles['mark-read']} onClick={() => onMark([item.id])}>
            标记为已读
          </span>
        </div>
        <div className={styles.time}>
          <span>{createdAt}</span>
        </div>
        <div className={styles.notice}>
          <a>您有新的xxxxx订单，请查看</a>
        </div>
      </div>
    );
  };

  return (
    <div className={classNames(styles['message-reminder'], styles[animationClass])}>
      <div className={styles['message-reminder__header']}>
        <div className={styles['message-reminder__header--title']}>
          消息提醒
          <span className={styles.close} onClick={toggle}>
            <CloseOutlined />
          </span>
        </div>
      </div>
      <div className={styles['message-reminder__body']}>
        <div className={styles['message-reminder__body--list']}>
          {messageData.length ? (
            messageData
              .filter((e, i) => i < 10)
              .map(item => <ReminderItem key={item.id} item={item} />)
          ) : (
            <Empty text="暂无数据" />
          )}
        </div>
      </div>
      <div className={styles['message-reminder__footer']}>
        <div className={styles['message-reminder__footer--actions']}>
          <div className={styles.more} onClick={openComplex}>
            查看更多
          </div>
          <div
            className={styles['mark-all']}
            onClick={() => {
              onMark(messageData.filter((e, i) => i < 10).map(item => item.id));
            }}
          >
            全部标记为已读
          </div>
        </div>
      </div>
    </div>
  );
};

const Simple = props => {
  const { dispatch, unReadCount, complexRef, unReadData } = props;
  const [visible, setVisible] = useState(false);
  const [count, setCount] = useState(0);
  const [hornClass, setHornClass] = useState('');
  const [messageClass, setMessageClass] = useState('');

  const [messageData, setMessageData] = useState([]);

  const userInfo = JSON.parse(localStorage.getItem('user') || '{}');

  const toggle = () => {
    setVisible(!visible);
  };

  // 初始化获取数据
  const getMsgList = async () => {
    const params = {
      pageNo: 1,
      pageSize: 1000,
    };
    const data = {
      channelId: CHANNEL_ID,
      bussinessId: userInfo.supplierCode,
      readStatus: 0,
    };
    const res = await apiGetBussinessMsgList(data, params);
    if (res.code !== '0000') {
      notification.error(res.msg);
      return;
    }
    console.log(res);
    const { content } = res.data;
    setVisible(!!content.length);
    dispatch({
      type: 'messageReminder/setUnReadData',
      payload: content,
      options: {
        unReadCount: content.length,
      },
    });
  };

  // 打开消息提醒弹框
  const openComplex = () => {
    complexRef.current.open();
    toggle();
  };

  // 标记已读信息
  const onMark = idList => {
    const payload = {
      channelId: CHANNEL_ID,
      bussinessId: userInfo.supplierCode,
      idList,
    };
    dispatch({
      type: 'messageReminder/setMarkRead',
      payload,
    });
  };

  useEffect(() => {
    setCount(unReadCount);
  }, [unReadCount]);

  useEffect(() => {
    setHornClass(visible ? 'hide' : 'show');
    setMessageClass(visible ? 'show' : 'hide');
  }, [visible]);

  useEffect(() => {
    getMsgList();
  }, []);

  useEffect(() => {
    setMessageData(unReadData);
  }, [unReadData]);

  const hornProps = {
    animationClass: hornClass,
    toggle,
    count,
  };

  const messageProps = {
    animationClass: messageClass,
    toggle,
    messageData,
    openComplex,
    onMark,
  };

  // 隐藏消息提醒
  return (
    <>
      <Horn {...hornProps} />
      <Message {...messageProps} />
    </>
  );
};

export default connect(({ messageReminder }) => ({
  unReadCount: messageReminder.unReadCount,
  unReadData: messageReminder.unReadData,
}))(Simple);
