import React, { useState, useEffect, forwardRef, useImperativeHandle } from 'react';
import { Modal, Tabs, Pagination } from 'antd';
import styles from './index.less';

const Complex = (props, ref) => {
  const [visible, setVisible] = useState(false);
  const [dataTotal, setDataTotal] = useState(10);
  const [pagination, setPagination] = useState({
    pageSize: 20,
    pageNo: 1,
  });

  // 分页操作
  const onPageChange = (page, size) => {
    const current = pagination.pageSize !== size ? 1 : page;
    setPagination({
      pageNo: current,
      pageSize: size,
    });
  };

  useEffect(() => {}, [pagination]);

  const open = () => {
    setVisible(true);
  };

  const close = () => {
    setVisible(false);
  };

  useImperativeHandle(ref, () => ({
    open,
  }));

  const modalProps = {
    width: '1000px',
    height: '600px',
    visible,
    title: '消息提醒',
    footer: null,
    onCancel: close,
  };

  return (
    <Modal {...modalProps}>
      <Tabs tabPosition="left">
        <Tabs.TabPane
          tab={
            <span>
              1111<span style={{ background: 'red' }}>abc</span>
            </span>
          }
          key="1"
        >
          <div className={styles['complex-list']}>
            <div className={styles['complex-list__item']}>
              <div className={styles['complex-list__item--header']}>
                <span className={styles.notice}>新的xxx订单，请查看</span>
                <span className={styles.orderNumber}> 订单编号：1562742258351251456</span>
                <span className={styles.time}>2022-10-13 12:22:03</span>
              </div>
              <div className={styles['complex-list__item--body']}>
                <div className={styles.good}>
                  <span className={styles.good__name}>商品名称商品名称商品名称商品名称</span>
                  <span className={styles.good__count}>x10</span>
                </div>

                <div className={styles.good}>
                  <span className={styles.good__name}>商品名称商品名称商品名称商品名称</span>
                  <span className={styles.good__count}>x10</span>
                </div>

                <div className={styles.good}>
                  <span className={styles.good__name}>商品名称商品名称商品名称商品名称</span>
                  <span className={styles.good__count}>x10</span>
                </div>
              </div>
              <div className={styles['complex-list__item--footer']}>
                <div className={styles.actions}>
                  <a>标记为已读</a>
                  <a>立即查看</a>
                </div>
              </div>
            </div>

            <div className={styles['complex-list__item']}>
              <div className={styles['complex-list__item--header']}>
                <span className={styles.notice}>新的xxx订单，请查看</span>
                <span className={styles.orderNumber}> 订单编号：1562742258351251456</span>
                <span className={styles.time}>2022-10-13 12:22:03</span>
              </div>
              <div className={styles['complex-list__item--body']}>
                <div className={styles.good}>
                  <span className={styles.good__name}>商品名称商品名称商品名称商品名称</span>
                  <span className={styles.good__count}>x10</span>
                </div>

                <div className={styles.good}>
                  <span className={styles.good__name}>商品名称商品名称商品名称商品名称</span>
                  <span className={styles.good__count}>x10</span>
                </div>

                <div className={styles.good}>
                  <span className={styles.good__name}>商品名称商品名称商品名称商品名称</span>
                  <span className={styles.good__count}>x10</span>
                </div>
              </div>
              <div className={styles['complex-list__item--footer']}>
                <div className={styles.actions}>
                  <a>标记为已读</a>
                  <a>立即查看</a>
                </div>
              </div>
            </div>
          </div>
        </Tabs.TabPane>
        <Tabs.TabPane tab="售后消息" key="2">
          <div className={styles['complex-list']}></div>
        </Tabs.TabPane>
      </Tabs>

      <div className={styles.pagination}>
        <Pagination
          onChange={onPageChange}
          total={dataTotal}
          showTotal={(total, range) => `第${range[0]}-${range[1]}条 /总共${total}条`}
          pageSize={pagination.pageSize}
          current={pagination.pageNo}
        />
      </div>
    </Modal>
  );
};

export default forwardRef(Complex);
