import React, {
  useContext,
  useState,
  useEffect,
  forwardRef,
  useImperativeHandle,
  useRef,
} from 'react';
import {
  Form,
  Input,
  Select,
  Button,
  Checkbox,
  Radio,
  Space,
  Modal,
  Switch,
  InputNumber,
  Cascader,
  Divider,
} from 'antd';
import { Title } from './CommonTemplate';
import { formItemLayout, ENUM_REPERTORY, ENUM_SET_REPERTORY } from '../config';
import { ServiceContext } from '../context';
import { debounce } from '@/utils/utils';
import UploadImage from './UploadImage';
import AddSellTimeModal from './AddSellTimeModal';
import styles from '../common.less';
import AddRepertoryModal from './AddRepertoryModal';
import AddMultiSpecModal from './AddMultiSpecModal';

const createInitValues = () => ({
  settlementMethod: 1,
  limitPurchase: null, // 是否限购1:限购/0:不限购
  limitPurchaseType: null, // 限购类型，如果限购必填1:长期限购/2:周期限购
  limitPurchaseCycle: null, // 限购周期1：每天/7：7天/30：30天
  limitPurchaseQuantity: null, // 限购数量
  packageContent: '',

  appointment: null, // 预约
  receptionVolume: null,
});

const TakeawayGoodsInfo = forwardRef((props, ref) => {
  const { editData } = props;
  const [form] = Form.useForm();
  const [initValue, setInitValue] = useState(createInitValues());
  const customer = useContext(ServiceContext);
  const [detailImageList, setDetailImageList] = useState([]);
  const [newCategoryList, setNewCategoryList] = useState({});
  const addSellTimeRef = useRef(null);
  const AddRepertoryRef = useRef(null);
  const AddMultiSpecRef = useRef(null);

  // 自定义加入菜单
  const showModal = () => {
    addSellTimeRef.current.setOpen(true);
  };

  const onCheck = async () => {
    try {
      const values = await form.validateFields();
      return {
        ...values,
        temp: 'settlementItem',
        limitPurchase: values.limitPurchase ? 1 : 0,
      };
    } catch (errorInfo) {
      return null;
    }
  };

  const getFormValues = debounce(() => {
    const values = form.getFieldsValue();
    console.log('values========', values);

    props.onValuesChange({ settlementItem: values });
  }, 400);

  const fileterBrandOptions = (input, options) => options.children.includes(input);

  const filterCategoryOptions = (inputValue, path) =>
    path.some(option => option.name.toLowerCase().indexOf(inputValue.toLowerCase()) > -1);

  useEffect(() => {
    if (customer.isEdit || customer.isUseCache) {
      if (!editData) return;
      form.setFieldsValue(editData);
      setInitValue({ ...editData });
    }
  }, [customer.isEdit, customer.isUseCache, editData]);

  useImperativeHandle(ref, () => ({
    onCheck,
    reset: () => {
      setInitValue(createInitValues());
      form.resetFields();
    },
  }));

  // 上传图片
  const onCardSuccessImageList = imgList => {
    setDetailImageList(imgList);
    form.setFieldsValue({
      detailImageList: imgList,
    });
  };
  const radioChangeEvent = key => {
    const value = form.getFieldValue(key);
    setInitValue({
      ...initValue,
      [key]: value,
    });
  };
  // 自定义菜单下拉
  const dropdownRender = menus => (
    <div>
      {menus}
      <Divider
        style={{
          margin: 0,
        }}
      />
      <div
        style={{
          padding: 8,
          background: '#1890ff',
          color: '#fff',
          textAlign: 'center',
        }}
        onClick={showModal}
      >
        添加自定售卖时间
      </div>
    </div>
  );
  const onChange3 = () => {};
  // 显示加入库存弹框
  const showAddRepertoryModal = () => {
    AddRepertoryRef.current.setOpenRepertory(true);
  };
    // 显示加入库存弹框
    const showMultiRepertoryModal = () => {
      AddMultiSpecRef.current.setMultiRepertory(true);
    };
  const onFinish = values => {
    console.log('Received values of form:', values);
  };
  return (
    <>
      <Form
        {...formItemLayout}
        form={form}
        name="takeaway"
        initialValues={initValue}
        scrollToFirstError
        onValuesChange={getFormValues}
      >
        <Title title="商品详细信息" />
        <Form.Item name="receptionVolume" label="商品描述">
          <Input.TextArea
            showCount
            maxLength={200}
            style={{ width: 400 }}
            placeholder="请输入商品描述"
          />
        </Form.Item>
        <Form.Item
          name="detailImageList"
          label="商品图片"
          extra="支持.jpg/png格式图片，建议单张切片宽750像素，大小200kb左右，您可以拖拽图片调整顺序，最多上传5张。"
        >
          <UploadImage
            name="detailImageList"
            limit={5}
            disabled={customer.isDisabled}
            pictures={detailImageList}
            setPictureList={list => onCardSuccessImageList(list)}
          />
        </Form.Item>

        <Title title="商品售卖信息" />
        <Form.Item
          name="receptionVolume"
          label="最少购买"
          // rules={[{ required: true, message: '每日最低接待量' }]}
        >
          <InputNumber min={1} style={{ width: 200 }} placeholder="请输入购买量" />
        </Form.Item>
        <Form.Item
          name="categoryId"
          label="售卖时间"
          // rules={[{ type: 'array', required: true, message: '请输入售卖时间!' }]}
        >
          <Select
            placeholder="请选择售卖时间！"
            style={{ width: 200 }}
            disabled={customer.isEdit && customer.isNormal}
            // showSearch={{ filter: filterCategoryOptions }}
            // fieldNames={{ label: 'name', value: 'id', children: 'children' }}
            // onChange={props.onCategoryChange}
            options={[
              {
                value: '全时段',
                label: '全时段',
              },
            ]}
            dropdownRender={dropdownRender}
          />
        </Form.Item>
        <AddSellTimeModal ref={addSellTimeRef}></AddSellTimeModal>

        <Form.Item
          name="categoryId"
          label="商品标签"
          // rules={[{ type: 'array', required: true, message: '请输入售卖时间!' }]}
        >
          <Select
            placeholder="请选择售卖时间！"
            style={{ width: 200 }}
            disabled={customer.isEdit && customer.isNormal}
            // showSearch={{ filter: filterCategoryOptions }}
            // fieldNames={{ label: 'name', value: 'id', children: 'children' }}
            // onChange={props.onCategoryChange}
            options={[
              {
                value: '招牌',
                label: '招牌',
              },
            ]}
          />
        </Form.Item>
        <Form.Item name="appointment" label="单点不送">
          <Radio.Group>
            <Radio value={1}>是</Radio>
            <Radio value={0}>否</Radio>
          </Radio.Group>
          开启后顾客点单则此商品不可下单
        </Form.Item>
        <Form.Item name="appointment" label="列出商品">
          <Radio.Group>
            <Radio value={1}>是</Radio>
            <Radio value={0}>否</Radio>
          </Radio.Group>
          开启后平台展示商品
        </Form.Item>

        <Title title="规格信息" />

        <Form.Item label="份量" className={styles.required}>
          <Form.Item
            name="receptionVolume"
            style={{
              display: 'inline-block',
            }}
            rules={[{ required: true, message: '请输入分量' }]}
          >
            <InputNumber min={1} style={{ width: 200 }} placeholder="请输入数字" />
          </Form.Item>
          <Form.Item
            name="categoryId"
            rules={[{ type: 'array', required: true, message: '请选择单位' }]}
            style={{
              display: 'inline-block',
              margin: '0 8px',
            }}
          >
            <Cascader
              placeholder="请选择单位"
              disabled={customer.isEdit && customer.isNormal}
              showSearch={{ filter: filterCategoryOptions }}
              fieldNames={{ label: 'name', value: 'id', children: 'children' }}
              onChange={props.onCategoryChange}
              options={newCategoryList[customer.productType]}
            />
          </Form.Item>
        </Form.Item>
        <Form.Item
          name="销售价格"
          label="销售价格"
          rules={[{ required: true, message: '请输入销售价格' }]}
        >
          <InputNumber min={0} style={{ width: 200 }} placeholder="元" />
        </Form.Item>

        {/* <Form.Item label="限购" name="limitPurchase" valuePropName="checked">
        <Checkbox onChange={() => radioChangeEvent('limitPurchase')}>
          <b style={{ marginLeft: 10 }}>启用限购</b>
          <span style={{ marginLeft: 10 }} className="ant-form-text">
            限制每人可购买数量
          </span>
        </Checkbox>
      </Form.Item> */}

        <Form.Item label="库存" name="limitPurchase">
          <Radio.Group
            options={ENUM_REPERTORY}
            onChange={onChange3}
            value={1}
            buttonStyle="solid"
            optionType="button"
          />
        </Form.Item>

        <Form.Item label="单规格">
          <Button
            type="primary"
            size="small"
            onClick={() => {
              showAddRepertoryModal(true);
            }}
            shape="round"
          >
            添加规格
          </Button>
        </Form.Item>

        <Form.Item label="多规格">
          <Button
            type="primary"
            size="small"
            onClick={() => {
              showMultiRepertoryModal(true);
            }}
            shape="round"
          >
            添加多规格
          </Button>
          <Form.Item
            name="receptionVolume"
            label="多规格库存"
            className={styles.multiSpecification}
          >
            <Button size="small" style={{ marginBottom: '10px' }} shape="round">
              统一设置置库存
            </Button>
            <Form.Item label="多规格1">

              <div
                className={styles.specRepertory}
                onClick={() => {
                  showAddRepertoryModal(true);
                }}
              >
               去设置
              </div>
            </Form.Item>
          </Form.Item>
        </Form.Item>

        {/* 33333 */}

      </Form>
      {/* 加入库存 */}
      <AddRepertoryModal ref={AddRepertoryRef} />
      {/* 加入多规格 */}
      <AddMultiSpecModal ref={AddMultiSpecRef} />
    </>
  );
});

export default TakeawayGoodsInfo;
