import React, { useState } from 'react';
import { Modal, Table } from 'antd';
import { columns } from './staticdata';

const DraftModal = props => {
  const [pageInfo, setPageInfo] = useState({
    current: 1,
    pageSize: 4,
    total: 100,
  });
  const [dataSource, setdataSource] = useState([]);

  const onChange = (current, pageSize) => {
    setPageInfo({
      current,
      pageSize,
    });
  };

  const onClose = () => props.onCancel();

  const pagination = {
    ...pageInfo,
    onChange,
    onShowSizeChange: onChange,
  };

  return (
    <Modal
      visible={props.visible}
      title="草稿箱"
      onCancel={onClose}
      maskClosable={false}
      width="1000px"
    >
      <Table columns={columns} pagination={pagination} dataSource={dataSource} />
    </Modal>
  );
};

export default DraftModal;
