import React from 'react';
import { Input, Form, InputNumber, Button, notification } from 'antd';
import { isIntegerNotMust, isCheckPriceTwoDecimal } from '@/utils/validator';
import styles from './style.less';

export function column(specArr = []) {
  return [
    ...specArr,
    {
      title: '供货价',
      dataIndex: 'supplyPrice',
      width: 150,
      align: 'center',
      render: (_, row, index) => (
        <div>
          <Form.Item
            label=""
            key="supplyPrice"
            name={['data', index, 'supplyPrice']}
            initialValue={row.supplyPrice || 0}
            rules={[
              { required: true, message: '请输入供货价！' },
              { validator: isCheckPriceTwoDecimal },
            ]}
          >
            <Input allowClear />
          </Form.Item>
        </div>
      ),
    },
    {
      title: '市场价',
      width: 135,
      align: 'center',
      dataIndex: 'marketPrice',
      render: (_, row, index) => (
        <div>
          <span>{row.marketPrice}</span>
          <div className={styles.hidden}>
            <Form.Item label="" key="id" name={['data', index, 'skuId']} initialValue={row.id}>
              <input />
            </Form.Item>
          </div>
        </div>
      ),
    },
    {
      title: '重量(kg)',
      width: 135,
      align: 'center',
      dataIndex: 'weight',
    },
    {
      title: '库存',
      width: 120,
      dataIndex: 'productStock',
      align: 'center',
      render: (_, row, index) => (
        <div>
          <Form.Item
            label=""
            key="stock"
            name={['data', index, 'stock']}
            initialValue={row.productStock || 0}
            rules={[{ required: true, message: '请输入库存！' }, { validator: isIntegerNotMust }]}
          >
            <InputNumber min={0} max={500} />
          </Form.Item>
        </div>
      ),
    },
    {
      title: '库存预警',
      width: 120,
      dataIndex: 'productStockWarning',
      align: 'center',
    },
    {
      title: '商品自编码',
      dataIndex: 'thirdSkuNo',
      width: 200,
      align: 'center',
    },
  ];
}

export function columnManage() {
  return [
    {
      title: 'SKU编码',
      dataIndex: 'skuId',
      width: 200,
      align: 'center',
    },
    {
      title: 'SKU商品名称',
      align: 'center',
      dataIndex: 'skuName',
    },
    {
      title: '供应商价格',
      dataIndex: 'marketPrice',
      width: 160,
      align: 'center',
      sorter: (a, b) => a.supplyPrice - b.supplyPrice,
      render: (_, row) => (
        <div className={styles.price}>
          <p>市场价：{(row.marketPrice || 0).toFixed(2)}</p>
        </div>
      ),
    },
    {
      title: '操作',
      dataIndex: 'action',
      width: 150,
      align: 'center',
      render: (_, row) => (
        <div className={styles.actionBtn}>
          {this.canEditable && (row.state === 4 || (row.state >= 5 && row.updateState !== 1)) && (
            <Button
              key="edit"
              type="primary"
              size="small"
              className={styles.button}
              onClick={() => {
                this.serviceVisbleChange(row);
              }}
            >
              修改
            </Button>
          )}
          <Button
            key="viewP"
            type="primary"
            size="small"
            className={styles.button}
            onClick={() => this.audit(row.skuId)}
          >
            预览
          </Button>
        </div>
      ),
    },
  ];
}
