import React from 'react';
import { Table, Card } from 'antd';

const LogisticsForm = props => {
  const { value } = props;
  const columns = [
    {
      title: '商品自编码',
      dataIndex: 'orderSkuId',
      key: 'orderSkuId',
      width: 250,
    },
    {
      title: '商品名称',
      dataIndex: 'skuName',
      key: 'skuName',
      width: 250,
    },
    {
      title: '商品规格',
      dataIndex: 'skuAttr',
      key: 'skuAttr',
      width: 250,
    },
    {
      title: '商品数量',
      dataIndex: 'count',
      key: 'count',
      width: 150,
    },
    {
      title: '物流公司',
      dataIndex: 'expressCompanyName',
      key: 'expressCompanyName',
      width: 150,
    },
    {
      title: '物流单号',
      dataIndex: 'deliveryNo',
      key: 'deliveryNo',
      width: 150,
    },
  ];
  return (
    <Card title="商品详情" bordered={false} style={{ width: '100%' }}>
      <Table columns={columns} dataSource={value} rowKey={r => r.orderSkuId} pagination={false} />
    </Card>
  );
};

export default LogisticsForm;
