import React from 'react';
import { Modal, Table } from 'antd';

const RechargeDetailsModal = ({ visible, onClose, list }) => {
  const columns = [
    {
      title: '员工ID',
      dataIndex: 'id',
      key: 'id',
    },
    {
      title: '员工姓名',
      dataIndex: 'staffName',
      key: 'staffName',
    },
    {
      title: '充值余额',
      dataIndex: 'rechargeAmount',
      key: 'rechargeAmount',
    },
    {
      title: '充值时间',
      dataIndex: 'generateDate',
      key: 'generateDate',
    },
  ];

  return (
    <Modal visible={visible} title="充值明细" onCancel={onClose} footer={null}>
      <Table dataSource={list} columns={columns} pagination={false} border />
    </Modal>
  );
};

export default RechargeDetailsModal;
