/* eslint-disable no-unused-expressions */
import React, { useState, useEffect, forwardRef } from 'react';
import { Row, Col } from 'antd';
import styles from './index.less';
import CTreeNode from './CTreeNode';
// import { deepClone } from '@/utils/utils';

const CustomTree = forwardRef(props => {
  const [treeData, setTreeData] = useState([]);
  const [childrenList, setChildrenList] = useState([]);
  const [treeValue, setTreeValue] = useState([]);

  // 获取选中的值
  const getCheckValue = (list, isFrist) => {
    const arr = [];
    const getChildrenCheckValue = childrens => {
      childrens.forEach(item => {
        if (item.checked) {
          arr.push({ ...item, [props.valueKey]: item.key });
        } else if (item.children && !isFrist) {
          getChildrenCheckValue(item.children);
        }
      });
    };
    getChildrenCheckValue(list);
  };

  // 获取默认值是否选中
  const getIsChecked = (key, json) => {
    const checkfn = list => {
      list.forEach(item => {
        if (+item[props.valueKey || 'key'] === +key) {
          json.checked = !!item.checked;
          json.indeterminate = true;
          json.value = getCheckValue(item.children, 1);
        } else if (item.children) {
          checkfn(item.children);
        }
      });
    };
    props.value && props.value.length && checkfn(props.value, json);
  };

  const updateChildren = (list, isChecked) => {
    list.forEach(item => {
      item.indeterminate = isChecked;
      item.checked = isChecked;
      if (item.children && item.children.length) {
        item.value = isChecked ? item.children.map(c => c.key) : [];
        updateChildren(item.children, isChecked);
      } else {
        item.value = isChecked ? [item.key] : [];
      }
    });
  };

  const updateTreeData = list => {
    list.forEach(node => {
      let cksel = false;
      let cklen = 0;
      const value = [];
      if (node.children && node.children.length) {
        updateTreeData(node.children);
        let indeterminate = false;
        node.children.forEach(item => {
          if (node.checked || item.checked) {
            value.push(item.key);
          }
          item.indeterminate && (indeterminate = true);
        });
        cklen = value.length;
        node.checked = cklen === node.children.length;
        cksel = cklen === node.children.length || indeterminate;
      }
      node.indeterminate = cklen > 0 || cksel;
      node.value = value;
    });
  };

  const changeChecked = (list, ckey, isChecked, pkey) => {
    let key = '';
    list.forEach(node => {
      if (node.key === ckey) {
        node.checked = isChecked;
        const values = [...treeValue];
        if (isChecked) {
          const obj = { ...node };
          obj.children = [];
          values.push(obj);
        } else {
          key = pkey;
          const index = treeValue.findIndex(item => item.key === node.key);
          index > -1 && values.splice(index, 1);
        }
        setTreeValue(values);
        node.children && node.children.length && updateChildren(node.children, isChecked);
      } else if (node.children && node.children.length) {
        if (changeChecked(node.children, ckey, isChecked, node.key) === node.key) {
          node.checked = false;
          key = pkey;
        }
      }
    });
    return key;
  };

  const updateVisibleChildren = (list, visible) => {
    list.forEach(item => {
      item.visibleChildren = false;
      item.isLoading = false;
      if (item.children && item.children.length) {
        updateVisibleChildren(item.children, visible);
      }
    });
  };

  const updateVisible = (list, ckey, visible, pkey) => {
    let key = '';
    list.forEach(node => {
      node.isLoading = false;
      if (node.key === ckey) {
        node.visibleChildren = visible;
        key = pkey;
        node.isLeaf = node.children.length > 0;
        updateVisibleChildren(node.children, visible);
      } else if (node.children && node.children.length) {
        node.visibleChildren = false;
        if (updateVisible(node.children, ckey, visible, node.key) === node.key) {
          node.visibleChildren = true;
          key = pkey;
        } else {
          node.visibleChildren = false;
        }
      }
    });
    return key;
  };

  const onChange = (ckey, isChecked) => {
    const datas = [...treeData];
    changeChecked(datas, ckey, isChecked);
    updateTreeData(datas);
    // updateVisible(datas, ckey, true);
    console.log('datas :>> ', datas);
    console.log('treeValue :>> ', treeValue);
    // props.onChange(getCheckValue(datas));
    setTreeData(datas);
    // setTimeout(() => {
    //   props.onChange(treeValue);
    // }, 10);
  };

  const filterData = (arr, parentChecked) => {
    const list = [];
    arr.forEach(item => {
      const json = {
        label: item.addrName,
        key: +item.addrId,
        level: item.addrLevel,
        value: [],
        checked: parentChecked || false,
        indeterminate: false,
        children: [],
        isLeaf: true,
        isLoading: false,
      };
      if (!parentChecked) {
        getIsChecked(item.addrId, json);
      }
      list.push(json);
    });
    return list;
  };

  const appendTreeData = (list, key, children) =>
    list.map(node => {
      if (node.key === key) {
        return {
          ...node,
          children: children.length ? children : undefined,
        };
      }
      if (node.children) {
        return {
          ...node,
          children: appendTreeData(node.children, key, children),
        };
      }
      return node;
    });

  const ChangeVal = (list, key, v, keyName) => {
    list.forEach(node => {
      if (node.key === key) {
        node[keyName] = v;
      } else if (node.children && node.children.length) {
        ChangeVal(node.children, key, v);
      }
    });
  };

  const getChildrenList = list => {
    const arr = [];
    const findArr = childrens => {
      childrens.forEach(node => {
        if (node.children && node.children.length) {
          node.visibleChildren && arr.push(node.children);
          findArr(node.children);
        }
      });
    };
    findArr(list);
    return arr;
  };

  const onVisibleChildren = async (ckey, visible, children, parentChecked) => {
    let arr = [...treeData];
    console.log('arr :>> ', arr);
    if (children && !children.length && typeof props.loadData === 'function') {
      ChangeVal(arr, ckey, true, 'isLoading');
      setTreeData(arr);
      const res = await props.loadData({ key: ckey, children });
      if (res && res.length) {
        arr = appendTreeData(arr, ckey, filterData(res, parentChecked));
      }
    }
    updateVisible(arr, ckey, visible);
    updateTreeData(arr);
    setChildrenList(getChildrenList(arr));
    setTreeData(arr);
  };

  const renderTreeNodes = data =>
    data &&
    data.map(item => (
      <CTreeNode
        label={item.label}
        onChange={onChange}
        onVisibleChildren={onVisibleChildren}
        key={item.key}
        treeData={item}
      />
    ));

  const handleMouseUp = e => {
    const isCur = e.path.some(item => item.id === 'my-custom-tree-box');
    if (!isCur) {
      onVisibleChildren('', false);
    }
  };

  const fitTreeValue = () => {
    const arr = [];
    const fitChildrenTreeValue = list => {
      list.forEach(item => {
        if (typeof item.checked === 'boolean') {
          if (item.checked) {
            arr.push(item);
          } else if (item.children && item.children.length) {
            fitChildrenTreeValue(item.children);
          }
        } else {
          arr.push(item);
        }
      });
    };
    fitChildrenTreeValue(props.value);
    setTreeValue(arr);
  };

  const initTreeData = (arr = [], level) =>
    arr.map(item => {
      const json = {
        value: item.value || [],
        level,
        visibleChildren: false,
        checked: false,
        indeterminate: false,
        label: item[props.labelName || 'label'],
        key: item[props.keyName || 'key'],
        isLeaf: true,
        isLoading: false,
      };
      getIsChecked(item.key, json);
      if (item.children) {
        json.children = initTreeData(item.children, level + 1);
      }
      return json;
    });

  const initTreeValue = (arr = []) =>
    arr.forEach(item => {
      item.checked = props.value.some(val => +val[props.valueKey || 'key'] === +item.key);
      if (item.children) {
        initTreeValue(item.children);
      }
    });

  useEffect(() => {
    const datas = [...treeData];
    console.log('props.value :>> ', props.value);
    fitTreeValue();
    initTreeValue(datas);
    updateTreeData(datas);
    setTreeData(datas);
  }, [props.value]);

  useEffect(() => {
    const arr = initTreeData(props.treeData, 1);
    setTreeData(arr);
  }, [props.treeData]);

  useEffect(() => {
    window.addEventListener('mouseup', handleMouseUp);
    return () => {
      window.removeEventListener('mouseup', handleMouseUp);
    };
  }, [treeData]);

  useEffect(
    e => {
      console.log('e :>> ', e);
      // props.onChange(treeValue);
    },
    [treeValue],
  );

  return (
    <div className={styles['tree-box']} id="my-custom-tree-box">
      <Row justify="space-between">
        {(treeData.length &&
          treeData.map(item => (
            <Col span={7} key={`col${item.key}`}>
              <div className={styles['tree-box--wrapper']}>
                <CTreeNode
                  label={item.label}
                  onChange={onChange}
                  onVisibleChildren={onVisibleChildren}
                  key={item.key}
                  treeData={item}
                ></CTreeNode>
                {(item.visibleChildren && childrenList && childrenList.length && (
                  <div className={styles['tree-children-box']}>
                    {childrenList.map(arr => (
                      <div className={styles['tree-children-wrapper']}>
                        {renderTreeNodes(arr) || ''}
                      </div>
                    ))}
                  </div>
                )) ||
                  ''}
              </div>
            </Col>
          ))) ||
          ''}
      </Row>
    </div>
  );
});
CustomTree.CTreeNode = CTreeNode;

export default CustomTree;
