import React, { forwardRef } from 'react';
import { Checkbox } from 'antd';
import { CaretRightOutlined, CaretDownOutlined, LoadingOutlined } from '@ant-design/icons';
import debounce from 'lodash/debounce';
import styles from './index.less';

const CustomTree = forwardRef(props => {
  const { treeData } = props;

  const onChange = () => {
    props.onChange(treeData.key, !treeData.checked);
  };

  const onVisible = debounce(e => {
    e.persist();
    props.onVisibleChildren(
      treeData.key,
      !treeData.visibleChildren,
      treeData.children,
      treeData.checked,
    );
  }, 100);

  const renderIcon = () => {
    if (treeData.children && treeData.isLoading) {
      return <LoadingOutlined />;
    }
    if (treeData.isLeaf) {
      return (
        <div onClick={onVisible}>
          {treeData.visibleChildren ? <CaretDownOutlined /> : <CaretRightOutlined />}
        </div>
      );
    }
    return <span />;
  };
  return (
    <div className={styles['ccheck-wrapper']} key={`key${treeData.key}`}>
      <div className={styles['ccheck-box']}>
        <div className={styles['ccheck-box--expand']}>{renderIcon()}</div>
        <Checkbox
          onChange={onChange}
          indeterminate={!treeData.checked && treeData.indeterminate}
          checked={treeData.checked}
        >
          {props.label}
          {treeData.value && treeData.value.length > 0 ? `(${treeData.value.length})` : ''}
        </Checkbox>
      </div>
    </div>
  );
});

export default CustomTree;
