import React from 'react';
import SuperSelect from 'antd-virtual-select';
import { Form, Modal, Card, Cascader, Select, Radio } from 'antd';
import { productTypeList } from '../staticdata';

const { Option } = Select;

const filterOption = (input, op) => op.props.children.includes(input);

const OperationForm = props => {
  const {
    operationVisible,
    setOperationVisible,
    categoryData,
    // virtualTreeData,
    shopList,
    barndList,
    // virtualBarndList,
    form,
  } = props;
  const { getFieldDecorator } = form;
  return (
    <Modal
      width="1050px"
      visible={operationVisible}
      onCancel={() => {
        setOperationVisible(false);
      }}
    >
      <Form layout="inline">
        <Card bordered={false}>
          <Form.Item label="商品类型：">
            {getFieldDecorator('productType', {
              initialValue: 1,
              rules: [{ required: true, message: '请选择商品类型' }],
            })(
              <Radio.Group>
                {productTypeList.map(item => (
                  <Radio key={item.value} value={item.value} disabled={item.disabled}>
                    {item.label}
                  </Radio>
                ))}
              </Radio.Group>,
            )}
          </Form.Item>
          <Form.Item label="类目：">
            {getFieldDecorator('categoryId', {
              rules: [{ required: true, message: '请选择类目' }],
            })(
              <Cascader
                style={{ width: 690 }}
                changeOnSelect
                showSearch
                fieldNames={{ label: 'name', value: 'id', children: 'children' }}
                options={categoryData}
              />,
            )}
          </Form.Item>
          <Form.Item label="供货商">
            {getFieldDecorator('supplierId', {
              rules: [{ required: true, message: '请选择供货商' }],
            })(
              <Select allowClear showSearch style={{ width: 190 }} filterOption={filterOption}>
                {shopList.map(item => (
                  <Option key={item.id} value={item.id}>
                    {item.name}
                  </Option>
                ))}
              </Select>,
            )}
          </Form.Item>
          <Form.Item label="商品品牌">
            {getFieldDecorator('brandId', {
              rules: [{ required: true, message: '请选择商品品牌' }],
            })(
              <SuperSelect allowClear showSearch style={{ width: 190 }} filterOption={filterOption}>
                {barndList.map(item => (
                  <Option key={item.id} value={item.id}>
                    {item.name}
                  </Option>
                ))}
              </SuperSelect>,
            )}
          </Form.Item>
        </Card>
      </Form>
    </Modal>
  );
};
export default Form.create()(OperationForm);
