import React, { useEffect } from 'react';
import { Cascader, Form, Input, Select, InputNumber, Button } from 'antd';
import { stateList } from '../staticdata';
import styled from '../style.less';

const FormItem = Form.Item;
const { Option } = Select;
const ItemWidth = { width: 300 };

const formItemLayout = {
  labelCol: {
    xs: { span: 8 },
    sm: { span: 8 },
  },
  wrapperCol: {
    xs: { span: 16 },
    sm: { span: 16 },
  },
};

const WrappedNormalLoginForm = props => {
  const { categoryData, form } = props;
  const { getFieldDecorator, getFieldValue, getFieldsValue, resetFields } = form;

  const filterOption = (input, op) => op.props.children.includes(input);

  const onSearch = () => {
    const formValue = getFieldsValue();
    props.onSearch(formValue);
  };
  const onReset = () => {
    resetFields();
    props.onReset();
  };

  useEffect(() => {
    onSearch();
  }, []);

  return (
    <Form layout="inline" {...formItemLayout}>
      <FormItem label="SKU编码" className={styled.formItem}>
        {getFieldDecorator('skuId', {})(<Input allowClear />)}
      </FormItem>
      <FormItem label="商品名称" className={styled.formItem}>
        {getFieldDecorator('skuName', {})(<Input allowClear />)}
      </FormItem>
      <FormItem label="类目" className={styled.formItem}>
        {getFieldDecorator('productCategoryId', {})(
          <Cascader
            changeOnSelect
            fieldNames={{ label: 'name', value: 'id', children: 'children' }}
            options={categoryData}
          />,
        )}
      </FormItem>
      <FormItem label="审核状态" className={styled.formItem}>
        {getFieldDecorator('state', {})(
          <Select allowClear showSearch filterOption={filterOption}>
            {stateList?.map(item => (
              <Option key={item.value} value={item.value}>
                {item.label}
              </Option>
            ))}
          </Select>,
        )}
      </FormItem>
      <FormItem label="供货价区间" className={styled.formItem}>
        <FormItem className={styled.itemSection}>
          {getFieldDecorator('supplyPriceMin', {})(<InputNumber style={{ width: '100%' }} />)}
        </FormItem>
        <span className={styled.itemLine}>-</span>
        <FormItem className={styled.itemSection}>
          {getFieldDecorator('supplyPriceMax', {})(
            <InputNumber style={{ width: '100%' }} min={getFieldValue('supplyPriceMin')} />,
          )}
        </FormItem>
      </FormItem>
      <FormItem label="第三方SKU编码" className={styled.formItem}>
        {getFieldDecorator('thirdSkuNo', {})(<Input allowClear />)}
      </FormItem>
      <FormItem className={styled.formItem}>
        <Button onClick={() => onSearch()} type="primary" className={styled.button}>
          查询
        </Button>
        <Button onClick={() => onReset()} type="primary" className={styled.button}>
          重置
        </Button>
      </FormItem>
    </Form>
  );
};
export const SearchForm = Form.create({ name: 'SearchForm' })(WrappedNormalLoginForm);

// import {
//   Button,
//   Form,
//   Input,
//   Select,
//   Popconfirm,
//   notification,
//   Upload,
//   Cascader,
//   InputNumber,
// } from 'antd';
// import React, { Component } from 'react';
// import { connect } from 'dva';
// import styles from '../style.less';
// import { stateList } from '../staticdata';
// import { batchPushedOrOffline, offline, uploadFile, importJdSkus } from '../service';

// const FormItem = Form.Item;
// const { Option } = Select;
// @connect(({ goodsManage }) => ({
//   goodsManage,
// }))
// class goodsManage extends Component {
//   componentDidMount() {
//     this.props.onRef(this);
//     this.handleSearch();
//   }

//   getFieldsValue() {
//     const { form } = this.props;
//     return form.getFieldsValue();
//   }

//   handleSearch = () => {
//     this.props.handleSearch(1);
//   };

//   onReset = () => {
//     this.props.form.resetFields();
//     this.props.onReset();
//   };

//   onConfirm = async isOffline => {
//     const [, error] = isOffline
//       ? await offline(this.props.selectedRowKeys)
//       : await batchPushedOrOffline({
//           ids: this.props.selectedRowKeys.join(),
//           type: 2,
//           productState: 6,
//           offlineReason: '',
//         });
//     this.props.onLoad(error);
//   };

//   addSpu = () => {
//     this.props.addSpu();
//   };

//   addVirtualSpu = () => {
//     this.props.addVirtualSpu();
//   };

//   importSkus = async (info, type) => {
//     const [result] = await importJdSkus(info.file, type);
//     if (result.businessCode === '0000') {
//       this.handleSearch();
//       notification.success({
//         message: '商品上传成功',
//       });
//     } else {
//       notification.warning({
//         message: result.msg,
//       });
//     }
//   };

//   render() {
//     const {
//       form: { getFieldDecorator, getFieldValue },
//       treeData,
//     } = this.props;
//     const selectW = {
//       width: 250,
//     };
//     const iptNumWidth = {
//       width: 118,
//     };
//     const that = this;

//     const uploadBatch = {
//       name: 'file',
//       async customRequest(info) {
//         that.importSkus(info, 0);
//       },
//       accept: '.xlsx',
//       showUploadList: false,
//     };

//     const uploadProps = {
//       name: 'file',
//       async customRequest(info) {
//         const [result] = await uploadFile(info.file);
//         if (result && result.businessCode === '0000') {
//           that.handleSearch();
//           notification.success({
//             message: '操作成功',
//           });
//         } else {
//           notification.warning({
//             message: result.msg,
//             description: (
//               <div>
//                 {result.data.length &&
//                   result.data.map(item => <p>{item.skuNo + item.errSkuMessage}</p>)}
//               </div>
//             ),
//             duration: 6,
//           });
//         }
//       },
//       accept: '.xlsx',
//       showUploadList: false,
//     };

//     const filterOption = (input, op) => op.props.children.includes(input);
//     return (
//       <Form name="horizontal_login" layout="inline" className={styles.searchForm}>
//         <FormItem label="SKU编码">
//           {getFieldDecorator('skuId', {})(<Input allowClear style={selectW} />)}
//         </FormItem>
//         <FormItem label="商品名称">
//           {getFieldDecorator('skuName', {})(<Input allowClear style={selectW} />)}
//         </FormItem>
//         <FormItem label="供应商名称">
//           {getFieldDecorator('supplierId', {})(
//             <Select style={selectW} allowClear showSearch filterOption={filterOption}>
//               {this.props.shopList?.map(item => (
//                 <Option key={item.id} value={item.id}>
//                   {item.name}
//                 </Option>
//               ))}
//             </Select>,
//           )}
//         </FormItem>
//         <FormItem label="第三方SKU编码">
//           {getFieldDecorator('thirdSkuNo', {})(<Input allowClear style={selectW} />)}
//         </FormItem>
//         <FormItem label="商品状态">
//           {getFieldDecorator('state', {})(
//             <Select style={selectW} allowClear showSearch filterOption={filterOption}>
//               {stateList?.map(item => (
//                 <Option key={item.value} value={item.value}>
//                   {item.label}
//                 </Option>
//               ))}
//             </Select>,
//           )}
//         </FormItem>
//         <FormItem label="类目">
//           {getFieldDecorator('productCategoryId', {})(
//             <Cascader
//               style={selectW}
//               changeOnSelect
//               fieldNames={{ label: 'name', value: 'id', children: 'children' }}
//               options={treeData}
//             />,
//           )}
//         </FormItem>
//         <FormItem label="供货价区间">
//           <FormItem className={styles.iptNumRight}>
//             {getFieldDecorator('supplyPriceMin', {})(<InputNumber style={iptNumWidth} />)}
//           </FormItem>
//           <span>--</span>
//           <FormItem className={styles.iptNumRight}>
//             {getFieldDecorator('supplyPriceMax', {})(
//               <InputNumber style={iptNumWidth} min={getFieldValue('supplyPriceMin')} />,
//             )}
//           </FormItem>
//         </FormItem>
//         <FormItem label="重量区间">
//           <FormItem className={styles.iptNumRight}>
//             {getFieldDecorator('weightMin', {})(<InputNumber style={iptNumWidth} precision={3} />)}
//           </FormItem>
//           <span>--</span>
//           <FormItem className={styles.iptNumRight}>
//             {getFieldDecorator('weightMax', {})(
//               <InputNumber style={iptNumWidth} min={getFieldValue('weightMin')} precision={3} />,
//             )}
//           </FormItem>
//         </FormItem>
//         <FormItem className={styles.queryBtn}>
//           <Button onClick={() => this.handleSearch()} type="primary" className={styles.button}>
//             查询
//           </Button>
//           <Button onClick={() => this.onReset()} type="primary" className={styles.button}>
//             重置
//           </Button>
//         </FormItem>
//         <FormItem style={{ width: '100%', textAlign: 'right' }}>
//           <Button type="primary" className={styles.button} onClick={this.addSpu}>
//             新增商品
//           </Button>
//           {/* <Button type="primary" className={styles.button} onClick={this.addSpu}>
//             新增虚拟商品
//           </Button> */}
//           <Popconfirm
//             placement="topLeft"
//             title="确定要上架吗？"
//             onConfirm={() => this.onConfirm()}
//             okText="确定"
//             cancelText="取消"
//           >
//             <Button
//               type="primary"
//               className={styles.button}
//               disabled={!this.props.selectedRowKeys.length}
//             >
//               批量上架
//             </Button>
//           </Popconfirm>
//           <Button.Group>
//             <Button
//               type="primary"
//               icon="download"
//               ghost
//               onClick={() => {
//                 window.location.href = 'https://kdspstatic.q-gp.com/batchSkuImportTemplatev4.xlsx';
//               }}
//             >
//               模版
//             </Button>
//             <Upload {...uploadBatch}>
//               <Button type="primary" icon="upload">
//                 批量新增
//               </Button>
//             </Upload>
//           </Button.Group>
//           <Button.Group style={{ marginLeft: '10px' }}>
//             <Button
//               type="primary"
//               icon="download"
//               ghost
//               onClick={() => {
//                 window.location.href =
//                   'https://kdspstatic.q-gp.com/batchUpdateSkuImportTempletv3.xlsx';
//               }}
//             >
//               模版
//             </Button>
//             <Upload {...uploadProps}>
//               <Button type="primary">批量修改</Button>
//             </Upload>
//           </Button.Group>
//         </FormItem>
//       </Form>
//     );
//   }
// }

// export default Form.create()(goodsManage);
