/* eslint-disable no-param-reassign */
import React from 'react';
import { Cascader, Select, InputNumber, Button } from 'antd';
import { stateList } from './staticdata';

const filterOption = (input, op) => op.props.children.includes(input);

export const toolBarList = () => [
  <Button key="getOffGoodsShelf" type="primary">
    新增商品
  </Button>,
  <Button key="putGoodsShelf">模版</Button>,
  <Button key="tags" type="primary">
    批量修改库存
  </Button>,
];

export const Goodscolumns = ({ categoryData, supplyPrice, setSupplyPrice, supplyPriceRef }) => [
  {
    title: 'SKU编码',
    dataIndex: 'skuId',
    key: 'skuId',
  },
  {
    title: 'SKU商品名称',
    dataIndex: 'skuName',
    key: 'skuName',
  },
  {
    title: '供应商名称',
    dataIndex: 'shopId',
    key: 'shopId',
    hideInTable: true,
    valueType: 'cascader',
    renderFormItem: () => (
      <Cascader
        changeOnSelect
        fieldNames={{ label: 'name', value: 'id', children: 'children' }}
        options={categoryData}
      />
    ),
  },
  {
    title: '审核状态',
    dataIndex: 'state',
    key: 'state',
    hideInTable: true,
    valueType: 'select',
    renderFormItem: () => (
      <Select allowClear showSearch filterOption={filterOption}>
        {stateList?.map(item => (
          <Select.Option key={item.value} value={item.value}>
            {item.label}
          </Select.Option>
        ))}
      </Select>
    ),
  },
  {
    title: '供货价区间',
    hideInTable: true,
    dataIndex: 'supplyPrice',
    modalHide: true,
    renderFormItem: () => [
      <div key="supplyPrice" className="search-profit-margin">
        <InputNumber
          key="min"
          placeholder="请输入"
          onChange={value => {
            supplyPrice[0] = value;
            setSupplyPrice(supplyPrice);
          }}
        />
        <span className="line">-</span>
        <InputNumber
          ref={supplyPriceRef}
          key="max"
          placeholder="请输入"
          onChange={value => {
            supplyPrice[1] = value;
            setSupplyPrice(supplyPrice);
          }}
        />
      </div>,
    ],
  },
  {
    title: '第三方SKU编码',
    dataIndex: 'thirdSkuNo',
    key: 'thirdSkuNo',
    hideInTable: true,
  },
  {
    title: '价格',
    dataIndex: 'supplyPrice',
    key: 'supplyPrice',
    hideInSearch: true,
    render: (value, row) => (
      <>
        <p>
          供货价：<a>{value}</a>
        </p>
        <p>
          市场价：<a>{row.marketPrice}</a>
        </p>
      </>
    ),
  },
  {
    title: '库存',
    dataIndex: 'stock',
    key: 'stock',
    hideInSearch: true,
    render: (value, row) => (
      <>
        <p>
          当前库存：<a>{row.productStock}</a>
        </p>
        <p>可售库存：{value}</p>
        {row.type === 1 && row.productStockWarning > -1 && <p>预警值：{row.productStockWarning}</p>}
      </>
    ),
  },
  {
    title: '商品状态',
    dataIndex: 'stateDesc',
    key: 'stateDesc',
    hideInSearch: true,
  },
  {
    title: '操作',
    key: 'option',
    dataIndex: 'option',
    valueType: 'option',
    fixed: 'right',
    modalHide: true,
    render: () => (
      <>
        <Button key="update" type="link" onClick={() => {}}>
          修改
        </Button>
        <Button key="preview" type="link" onClick={() => {}}>
          预览
        </Button>
        <Button key="seelog" type="link" onClick={() => {}}>
          查看日志
        </Button>
      </>
    ),
  },
];
