import { Button, Form, Input, Select, notification, Modal, InputNumber } from 'antd';
import React, { Component } from 'react';
import { connect } from 'dva';
import { getJdPicList, addSku, updateSku } from '../service';
import Upload from '../../components/upload';
import style from '../style.less';

const FormItem = Form.Item;
const { Option } = Select;
@connect(({ goodsManage }) => ({
  goodsManage,
}))
class goodsManage extends Component {
  componentDidMount() {
    this.handleDataList();
    this.categoryList(null, 'cid1List');
  }

  shouldComponentUpdate(nextProps) {
    // 应该使用这个方法，否则无论props是否有变化都将会导致组件跟着重新渲染
    const initForm = nextProps.initForm || {};

    if (initForm?.cid1 !== this?.props?.initForm.cid1) {
      this.categoryList(initForm?.cid1, 'cid2List');
      this.categoryList(initForm?.cid2, 'cid3List');
    }

    return true;
  }

  categoryList = (value, categoryNum) => {
    const { dispatch } = this.props;
    dispatch({
      type: 'goodsManage/categoryList',
      payload: {
        categoryNum,
        value,
      },
    });
  };

  handleDataList = () => {
    const { dispatch } = this.props;
    dispatch({
      type: 'goodsManage/getDataList',
    });
  };

  handleSearch = () => {
    this.props.handleSearch();
  };

  onReset = () => {
    const {
      form: { resetFields },
    } = this.props;
    resetFields();
  };

  submit = () => {
    // 保存
    const {
      form: { validateFields },
      initForm = {},
    } = this.props;
    validateFields(async (errors, values) => {
      if (!errors) {
        const api = initForm?.id ?? '' ? updateSku : addSku;
        const error = await api({ ...values, id: initForm?.id });
        if (!error) {
          // 掉接口成功后关闭modal 清空数据
          notification.success({ message: '操作成功' });
          this.handleSearch();
          this.onCancel();
        }
      }
    });
  };

  // eslint-disable-next-line consistent-return
  getPic = async () => {
    //  获取图片需要设置轮播图和详情图
    const {
      form: { setFieldsValue, getFieldsValue },
    } = this.props;
    const { imageList = [], jdSkuInfoUrl, imageDetailList = [] } = getFieldsValue([
      'imageList',
      'jdSkuInfoUrl',
      'imageDetailList',
    ]);
    if (!jdSkuInfoUrl) {
      return notification.warning({ message: '请输入京东链接再获取图片' });
    }
    const data = await getJdPicList(jdSkuInfoUrl);
    if (data) {
      const { carouseList = [], detailList = [] } = data[0];
      setFieldsValue({
        imageList: [...imageList, ...carouseList],
        imageDetailList: [...imageDetailList, ...detailList],
      });
    }
  };

  normFile = fileList => fileList;

  afterClose = () => {
    this.onReset();
  };

  onCancel = () => {
    this.props.onCancel();
  };

  render() {
    const {
      form: { getFieldDecorator },
      goodsManage: { shopList = [], cid1List = [], cid2List = [], cid3List = [] },
      initForm = {},
      statusList = [],
    } = this.props;
    const carouseImageList = initForm?.carouseImageList?.map(item => item.imageUrl) || [];
    const detailImageList = initForm?.detailImageList?.map(item => item.imageUrl) || [];

    const filterOption = (input, op) => op.props.children.includes(input);
    const formItemLayout = {
      labelCol: { span: 5 },
      wrapperCol: { span: 13 },
    };
    const options =
      statusList.length &&
      statusList.map(d => (
        <Select.Option value={d.status} key={d.status}>
          {d.statusDesc}
        </Select.Option>
      ));
    const inputNumberSty = {
      width: '100%',
    };
    return (
      <Modal
        visible={this.props.visible}
        width={800}
        title={`商品${initForm.id ? '修改' : '添加'}`}
        onOk={this.submit}
        onCancel={this.onCancel}
        afterClose={this.afterClose}
      >
        <Form {...formItemLayout}>
          {initForm.id ? (
            <FormItem label="商品编码">
              {getFieldDecorator('skuNo', {
                initialValue: initForm.skuNo,
              })(<Input readOnly />)}
            </FormItem>
          ) : (
            ''
          )}
          <FormItem label="商品名称">
            {getFieldDecorator('skuName', {
              initialValue: initForm.skuName,
              rules: [
                {
                  required: true,
                  message: '请输入商品名称',
                },
              ],
            })(<Input allowClear />)}
          </FormItem>
          <FormItem label="第三方sku编码">
            {getFieldDecorator('thirdSkuNo', {
              initialValue: initForm.thirdSkuNo,
              rules: [
                {
                  required: true,
                  message: '请输入第三方sku编码',
                },
              ],
            })(<Input allowClear readOnly={!!initForm.id} />)}
          </FormItem>
          <FormItem label="第三方spu编码">
            {getFieldDecorator('thirdSpuNo', {
              initialValue: initForm.thirdSpuNo,
              rules: [
                {
                  required: true,
                  message: '请输入第三方spu编码',
                },
              ],
            })(<Input allowClear readOnly={!!initForm.id} />)}
          </FormItem>
          <FormItem label="品牌名称">
            {getFieldDecorator('brandName', {
              initialValue: initForm.brandName,
              rules: [
                {
                  required: true,
                  message: '请输入品牌名称',
                },
              ],
            })(<Input allowClear />)}
          </FormItem>
          <FormItem label="成本价">
            {getFieldDecorator('costPrice', {
              initialValue: initForm.costPrice,
              rules: [
                {
                  required: true,
                  message: '请输入成本价',
                },
              ],
            })(<InputNumber allowClear style={inputNumberSty} precision={2} />)}
          </FormItem>
          {/* <FormItem label="市场价">
            {getFieldDecorator('marketPrice', {
              initialValue: initForm.marketPrice,
              rules: [
                {
                  required: true,
                  message: '请输入市场价',
                },
              ],
            })(<InputNumber allowClear style={inputNumberSty} precision={2} />)}
          </FormItem>
          <FormItem label="销售价">
            {getFieldDecorator('salePrice', {
              initialValue: initForm.salePrice,
              rules: [
                {
                  required: true,
                  message: '请输入销售价',
                },
              ],
            })(<InputNumber allowClear style={inputNumberSty} precision={2} />)}
          </FormItem> */}
          <FormItem label="库存">
            {getFieldDecorator('stock', {
              initialValue: initForm.stock,
              rules: [
                {
                  required: true,
                  message: '请输入库存',
                },
              ],
            })(<InputNumber allowClear style={inputNumberSty} />)}
          </FormItem>
          {initForm.id ? (
            <FormItem label="商品状态">
              {getFieldDecorator('status', {
                initialValue: initForm.status,
                rules: [{ required: true, message: '请输入商品状态' }],
              })(<Select allowClear>{options}</Select>)}
            </FormItem>
          ) : (
            ''
          )}
          <FormItem label="一级分类">
            {getFieldDecorator('cId1', {
              initialValue: initForm.cid1,
              rules: [
                {
                  required: true,
                  message: '请选择一级分类',
                },
              ],
            })(
              <Select
                allowClear
                onChange={value => this.categoryList(value, 'cid2List')}
                showSearch
                filterOption={filterOption}
              >
                {cid1List?.map(item => (
                  <Option key={item.categoryId} value={item.categoryId}>
                    {item.categoryName}
                  </Option>
                ))}
              </Select>,
            )}
          </FormItem>
          <FormItem label="二级分类">
            {getFieldDecorator('cId2', {
              initialValue: initForm.cid2,
              rules: [
                {
                  required: true,
                  message: '请选择二级分类',
                },
              ],
            })(
              <Select
                allowClear
                onChange={value => this.categoryList(value, 'cid3List')}
                showSearch
                filterOption={filterOption}
              >
                {cid2List?.map(item => (
                  <Option key={item.categoryId} value={item.categoryId}>
                    {item.categoryName}
                  </Option>
                ))}
              </Select>,
            )}
          </FormItem>
          <FormItem label="三级分类">
            {getFieldDecorator('cId3', {
              initialValue: initForm.cid3,
              rules: [
                {
                  required: true,
                  message: '请选择三级分类',
                },
              ],
            })(
              <Select allowClear showSearch filterOption={filterOption}>
                {cid3List?.map(item => (
                  <Option key={item.categoryId} value={item.categoryId}>
                    {item.categoryName}
                  </Option>
                ))}
              </Select>,
            )}
          </FormItem>
          <FormItem label="供应商名称">
            {getFieldDecorator('shopId', {
              initialValue: initForm?.shopId && +initForm?.shopId,
              rules: [
                {
                  required: true,
                  message: '请选择供应商名称',
                },
              ],
            })(
              <Select allowClear showSearch filterOption={filterOption}>
                {shopList?.map(item => (
                  <Option key={item.shopId} value={item.shopId}>
                    {item.shopName}
                  </Option>
                ))}
              </Select>,
            )}
          </FormItem>
          <FormItem label="规格1">
            {getFieldDecorator('attValue', {
              initialValue: initForm.attValue,
            })(<Input allowClear placeholder="格式名称：值" />)}
          </FormItem>
          <FormItem label="规格2">
            {getFieldDecorator('attValue2', {
              initialValue: initForm.attValue2,
            })(<Input allowClear placeholder="格式名称：值" />)}
          </FormItem>
          <FormItem label="京东链接">
            <div style={{ display: 'flex' }}>
              <FormItem>
                {getFieldDecorator('jdSkuInfoUrl', {
                  initialValue: initForm.jdSkuInfoUrl,
                })(<Input allowClear className={style.linkInput} />)}
              </FormItem>
              <Button type="primary" onClick={this.getPic} className={style.picBtn}>
                获取图片
              </Button>
            </div>
          </FormItem>
          <FormItem label="轮播图">
            {getFieldDecorator('imageList', {
              initialValue: carouseImageList,
              valuePropName: 'fileList',
              getValueFromEvent: this.normFile,
              rules: [
                {
                  required: true,
                  message: '请上传轮播图',
                },
              ],
            })(<Upload />)}
            (提示：轮播图的顺序是从左至右)
          </FormItem>
          <FormItem label="详情图">
            {getFieldDecorator('imageDetailList', {
              initialValue: detailImageList,
              valuePropName: 'fileList',
              getValueFromEvent: this.normFile,
            })(<Upload />)}
            (提示：详情图的顺序是从左至右)
          </FormItem>
        </Form>
      </Modal>
    );
  }
}

export default Form.create({})(goodsManage);
