import React from 'react';
import { Button, Upload } from 'antd';
import { UploadOutlined } from '@ant-design/icons';
import styles from './style.less';

export const payStateEnum = {
  1: { text: '待申请' },
  2: { text: '待审批' },
  3: { text: '已通过' },
  4: { text: '待打款' },
  5: { text: '已打款' },
  6: { text: '付款中（OA中）' },
  7: { text: '付款中（已OA）' },
  8: { text: '付款中（待打款）' },
};

export const orderStateNum = {
  1: { text: '待上传' },
  2: { text: '待审核' },
  3: { text: '未通过' },
  4: { text: '已通过' },
};

export const dateStateEnum = {
  1: { text: '周结' },
  2: { text: '半月结' },
  3: { text: '月结' },
  4: { text: '日结' },
  5: { text: '半日结' },
};

export const redInvoiceState = {
  1: { text: '是', actionValue: 2 },
  2: { text: '否', actionValue: 1 },
};

export function columns(res, pages) {
  const { current, pageSize } = pages;
  return [
    {
      title: '序号',
      dataIndex: 'index',
      hideInSearch: true,
      width: '50px',
      align: 'center',
      render: (text, record, index) => (current - 1) * pageSize + index + 1,
    },
    {
      title: '供应商名称',
      dataIndex: 'supplierName',
      width: '150px',
      hideInSearch: true,
    },
    {
      title: '付款单批次号',
      dataIndex: 'payBatchNo',
      width: '160px',
      align: 'center',
    },
    {
      title: '付款单生成日期',
      key: 'dateTimeRange',
      dataIndex: 'createdAtRange',
      valueType: 'dateRange',
      width: '120px',
      hideInTable: true,
      initialValue: [],
      align: 'center',
    },
    {
      title: '打款日期',
      key: 'payTimeRange',
      dataIndex: 'payAtRange',
      valueType: 'dateRange',
      width: '120px',
      hideInTable: true,
      initialValue: [],
      align: 'center',
    },
    {
      title: '帐单确认周期',
      dataIndex: 'createdAtRange',
      key: 'created',
      hideInSearch: true,
      align: 'center',
      width: '160px',
      render: (text, record) => `${record.billPeriodStart}-${record.billPeriodEnd}`,
    },
    {
      title: '付款单生成日期',
      dataIndex: 'createdAt',
      key: 'createdAt',
      hideInSearch: true,
      align: 'center',
      width: '160px',
    },
    {
      title: '销售总额',
      dataIndex: 'saleAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: '退款总额',
      dataIndex: 'refundAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: '红字金额',
      dataIndex: 'pastRefundAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: () => (
        <div style={{ textAlign: 'center' }}>
          <div>蓝字金额</div>
          <div style={{ color: '#f00' }}>(开票金额)</div>
        </div>
      ),
      dataIndex: 'currentRefundAmount',
      key: 'currentRefundAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: '应付金额',
      dataIndex: 'payableAmount',
      width: '140px',
      hideInSearch: true,
      align: 'center',
      render: (value, row) => (
        <div>
          <div>{row.payableAmount}</div>
          <div style={{ color: '#f00' }}>赔付 ({row.claimAmount})</div>
          <div>(实付 {row.needPayAmount})</div>
        </div>
      ),
    },
    {
      title: () => (
        <div style={{ textAlign: 'center' }}>
          <div>当前结算周期</div>
          <div style={{ color: '#f00' }}>(供应商维度)</div>
        </div>
      ),
      dataIndex: 'billPeriod',
      key: 'billPeriod',
      width: '150px',
      hideInSearch: true,
      valueEnum: dateStateEnum,
      align: 'center',
    },
    {
      title: () => (
        <div style={{ textAlign: 'center' }}>
          <div>拖欠金额</div>
          <div style={{ color: '#f00' }}>(供应商维度)</div>
        </div>
      ),
      dataIndex: 'arrearsAmount',
      key: 'arrearsAmount',
      width: '130px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: '实付金额',
      dataIndex: 'paidAmount',
      key: 'paidAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: '是否缺少红字发票',
      dataIndex: 'redInvoiceState',
      valueEnum: redInvoiceState,
      align: 'center',
      width: 100,
    },
    {
      title: '付款状态',
      dataIndex: 'payState',
      valueEnum: payStateEnum,
      width: '110px',
      align: 'center',
    },
    {
      title: '发票状态',
      dataIndex: 'blueInvoiceState',
      valueEnum: orderStateNum,
      width: '110px',
      align: 'center',
    },
    {
      title: '操作',
      dataIndex: 'option',
      // valueType: 'option',
      key: 'option',
      width: '220px',
      align: 'center',
      fixed: 'right',
      render: (_, row) => (
        <div>
          {res.canEditable ? (
            <>
              <Button
                type="primary"
                disabled={row.payState !== 1}
                className={styles.button}
                onClick={() => res.edit(0, row)}
              >
                申请结算
              </Button>
              {(row.billPeriod === 4 || row.billPeriod === 5) && row.blueInvoiceState === 4 ? (
                <Button type="primary" className={styles.button} onClick={() => res.edit(11, row)}>
                  补充发票
                </Button>
              ) : (
                <Button
                  type="primary"
                  disabled={
                    !(
                      (row.blueInvoiceState === 1 || row.blueInvoiceState === 3) &&
                      row.payState === 3
                    )
                  }
                  className={styles.button}
                  onClick={() => res.edit(1, row)}
                >
                  上传发票
                </Button>
              )}
            </>
          ) : (
            ''
          )}
          <Button
            type="primary"
            disabled={row.blueInvoiceState === 1}
            className={styles.button}
            onClick={() => res.edit(2, row)}
          >
            查看发票
          </Button>
          <Button type="primary" className={styles.button} onClick={() => res.edit(3, row)}>
            下载账单
          </Button>
          <Button
            type="primary"
            className={styles.btnMax}
            disabled={row.payState !== 5}
            onClick={() => res.onPaymentOrder(1, row)}
          >
            查看付款凭证
          </Button>
        </div>
      ),
    },
  ];
}

export const toolBarRender = onExport => () => [];

// 上传文件
export function uploadPropsFn({
  keyName,
  limit = 1,
  maxSize = 1024 * 1024 * 5,
  maxSizeMsg = '文件大小不能超过5M！',
  form,
  disabled,
  accept = '.png,.bmp,.gif,.jpeg,.jpg',
}) {
  const config = {
    maxSize,
    disabled,
    multiple: limit > 1,
    listType: 'picture-card',
    showUploadList: true,
    accept,
    onRemove: e => {
      const fileValue = form.getFieldValue(keyName) || [];
      if (fileValue.fileList) {
        const files = fileValue.fileList.filter(item => item.uid !== e.uid);
        form.setFieldValue(keyName, files);
      } else {
        const files = fileValue.filter(item => item.uid !== e.uid);
        form.setFieldValue(keyName, files);
      }
    },
  };
  return config;
}

/**
 * 付款单弹窗
 * status：1查看 0上传
 * * */
export const paymentInfoColumn = status => [
  {
    title: '付款单',
    dataIndex: 'images',
    key: 'images',
    formItemProps: {
      rules: [{ required: true, message: '请上传付款单' }],
    },
    fieldProps: {
      disabled: status === 1,
      limit: 1,
      accept: '.png,.bmp,.gif,.jpeg,.jpg,.pdf',
    },
    renderFormItem: (s, c, form) => {
      let fileList = form.getFieldValue('images') || [];
      if (fileList.fileList) {
        fileList = fileList.fileList || [];
      }
      return (
        <Upload
          {...uploadPropsFn.call(this, {
            keyName: 'images',
            form,
            accept: '.png,.bmp,.gif,.jpeg,.jpg,.pdf',
          })}
          fileList={fileList}
          disabled={status === 1}
        >
          <UploadOutlined /> 上传文件
        </Upload>
      );
    },
  },
  {
    title: '备注',
    dataIndex: 'comment',
    key: 'comment',
    align: 'center',
    valueType: 'textarea',
    fieldProps: {
      disabled: status === 1,
      maxLength: 200,
      autoSize: { minRows: 2, maxRows: 6 },
    },
  },
];

export const formItemLayout = {
  labelCol: { span: 6 },
  wrapperCol: { span: 18 },
};
