/* eslint-disable no-undef */
/* eslint-disable no-shadow */
/* eslint-disable no-return-assign */
import { Button, Upload, notification, Spin } from 'antd';
import React, { useRef, useEffect, useState } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import { columns, toolBarRender, dateStateEnum } from './data';
import { query, selfPaymentBill } from './service';

const SettlementSheet = () => {
  const actionRef = useRef();
  const [selectedRowKeys, setselectedRowKeys] = useState([]);
  const [selectedRowsList, setselectedRowsList] = useState([]);
  const [loading, setloading] = useState(false);

  const reload = () => {
    if (actionRef.current) {
      actionRef.current.reload();
    }
  };
  // 计算当前结算金额为0或负
  const checkedAmount = data => {
    const totalPrice = data.reduce(
      (totalPrice, item) => (totalPrice += Number(item.refundAmount)),
      0,
    );
    if (totalPrice <= 0) {
      notification.error({ message: '当前结算金额为0或负' });
    }
  };
  // 检查帐期类型的最多下载条数
  const checkedBillType = data => {
    if (!data.length) {
      notification.error({ message: '请选择数据' });
      return false;
    }
    const billPeriodType = data[0]?.billPeriodType;
    const billPeriodData = dateStateEnum[billPeriodType];
    if (data.length <= billPeriodData.maxlength) {
      return true;
    }
    notification.error({
      message: `${billPeriodData.text}帐期最多生成${billPeriodData.maxlength}付款单`,
    });
    return false;
  };
  // 检查帐期周期是否连续
  const checkedTime = data => {
    const minTime = data[0]?.billPeriodStart?.split(' ')[0];
    const maxTime = data[0]?.billPeriodEnd?.split(' ')[0];
    let minTimeNum = new Date(minTime).getTime();
    let maxTimeNum = new Date(maxTime).getTime();
    if (data.length < 2) {
      return true;
    }
    for (let i = 1; i < data.length; i += 1) {
      const startTime = data[i]?.billPeriodStart?.split(' ')[0];
      const endTime = data[i]?.billPeriodEnd?.split(' ')[0];
      const startTimeNum = new Date(startTime).getTime();
      const endTimeNum = new Date(endTime).getTime();
      if (startTimeNum > maxTimeNum && maxTimeNum + 24 * 3600 * 1000 === startTimeNum) {
        maxTimeNum = endTimeNum;
      } else if (minTimeNum > endTimeNum && endTimeNum + 24 * 3600 * 1000 === minTimeum) {
        minTimeNum = startTimeNum;
      }
    }
    const endRulstTime = data[data.length - 1]?.billPeriodEnd?.split(' ')[0];
    const endRulstTimeNum = new Date(endRulstTime).getTime();
    if (endRulstTimeNum === maxTimeNum) {
      return true;
    }
    notification.error({ message: '账单周期不连续' });
    return false;
  };

  const onSelectChange = (selectedRowKeys, selectedRows) => {
    if (selectedRowsList.length > selectedRows.length) {
      setselectedRowKeys(selectedRowKeys);
      setselectedRowsList(selectedRows);
    } else if (checkedTime(selectedRows)) {
      setselectedRowKeys(selectedRowKeys);
      setselectedRowsList(selectedRows);
    }
  };

  const paymentOrder = async () => {
    if (checkedBillType(selectedRows)) {
      setloading(true);
      checkedAmount(selectedRows);
      const data = await selfPaymentBill(selectedRowKeys);
      if (data.businessCode === '0000') {
        setselectedRowKeys([]);
        setselectedRows([]);
        reload();
        notification.success({ message: '生成付款单成功' });
      }
      setloading(false);
    }
  };

  const onToolBarRender = toolBarRender(paymentOrder);

  const rowSelection = {
    selectedRowKeys,
    onChange: onSelectChange,
    getCheckboxProps: record => ({
      disabled: !!(record.settleState === 1 && record.payBatchNo), // Column configuration not to be checked
    }),
  };

  const searchRender = ({ searchText, resetText }, { form }) => [
    <Button
      key="search"
      type="primary"
      style={{ marginRight: '10px' }}
      onClick={() => {
        // eslint-disable-next-line no-unused-expressions
        form?.submit();
      }}
    >
      {searchText}
    </Button>,
    <Button
      key="rest"
      style={{ marginRight: '10px' }}
      onClick={() => {
        // eslint-disable-next-line no-unused-expressions
        form?.resetFields();
      }}
    >
      {resetText}
    </Button>,
  ];
  return (
    <Spin tip="Loading..." spinning={loading} delay={100}>
      <PageHeaderWrapper>
        <ProTable
          actionRef={actionRef}
          request={params => query({ ...params })}
          columns={columns}
          rowKey={r => r.settleBatchNo}
          search={{
            collapsed: false,
            optionRender: searchRender,
          }}
          rowSelection={rowSelection}
          bordered
          toolBarRender={onToolBarRender}
          scroll={{ x: '100%' }}
        />
      </PageHeaderWrapper>
    </Spin>
  );
};

export default SettlementSheet;
