import React, { forwardRef, useImperativeHandle, useState, useRef, useEffect } from 'react';
import { Modal, Select, notification, Form, Input, Button, Checkbox } from 'antd';
import { PlusCircleOutlined, MinusCircleOutlined } from '@ant-design/icons';
import { userEnabled, userDisabled, userDelete } from '@/pages/systemManage/service';
import styles from './index.less';

const FormComponent = (props, ref) => {
  const { record = {}, companys = [] } = props;
  const { mchOrderSkuVoList } = record;
  const [form] = Form.useForm();
  const [skuInfoList, setSkuInfoList] = useState(mchOrderSkuVoList.map(item => ({})));

  const formLayout = {
    labelCol: { span: 0 },
    wrapperCol: { span: 24 },
  };
  const formRules = {
    expressCompanyCode: [{ required: true, message: '请选择物流公司' }],
    expressNo: [{ required: true, message: '请填写物流单号' }],
    serialNumber: [{ required: true, message: '请填写序列号' }],
  };

  useEffect(() => {
    console.log(companys, record.mchOrderSkuVoList);

    // setSkuInfoList(mchOrderSkuVoList.map(item=>{
    //   return {
    //     skuId: item.orderSkuId,
    //     quantity: 1
    //   }
    // }))
  }, [record]);

  useImperativeHandle(ref, () => ({
    form,
  }));

  const getSkuOptions = (index, parentIndex) => {
    const { skuId, skuName } = mchOrderSkuVoList[index];
    const packageList = form.getFieldValue('packageList');
    const updateFormValue = value => {
      packageList[parentIndex].skuInfoList[index].skuId = value;
      console.log(packageList);
      // form.setFieldsValue({
      //   packageList,
      // })
    };
    return (
      <Checkbox onChange={() => updateFormValue(skuId)} value={skuId}>
        {skuName}
      </Checkbox>
    );
  };

  const SkuFormList = skuProps => {
    const { skuFields, parentFields } = skuProps;
    return skuFields.map(field => {
      console.log(111111111, field, parentFields);
      return (
        <div className={styles['sku-list']}>
          <Form.Item className={styles['sku-list__goods-name']} name={[field.name, 'skuId']}>
            {getSkuOptions(field.name, parentFields.name)}
          </Form.Item>
          <Form.Item className={styles['sku-list__goods-count']} name={[field.name, 'quantity']}>
            <Input type="number" placeholder="请输入数量" />
          </Form.Item>
        </div>
      );
    });
  };

  return (
    <Form
      form={form}
      {...formLayout}
      initialValues={{
        packageList: [
          {
            skuInfoList,
          },
        ],
      }}
    >
      <Form.List name="packageList" rules={[]}>
        {(fields, { add, remove }, { errors }) => (
          <>
            {fields.map((field, index) => (
              <>
                <React.Fragment key={field.key}>
                  <Form.List name={[field.name, 'skuInfoList']}>
                    {skuFields => (
                      <SkuFormList
                        key={index.toString()}
                        skuFields={skuFields}
                        parentFields={field}
                      />
                    )}
                  </Form.List>
                  <Form.Item
                    name={[field.name, 'expressCompanyCode']}
                    rules={formRules.expressCompanyCode}
                  >
                    <Select
                      placeholder="请选择物流公司"
                      fieldNames={{ label: 'expressCompanyName', value: 'expressCompanyCode' }}
                      options={companys}
                    ></Select>
                  </Form.Item>
                  <Form.Item name={[field.name, 'expressNo']} rules={formRules.expressNo}>
                    <Input placeholder="请填写物流单号" />
                  </Form.Item>
                  <Form.Item name={[field.name, 'serialNumber']} rules={formRules.serialNumber}>
                    <Input placeholder="请填写序列号" />
                  </Form.Item>
                </React.Fragment>
              </>
            ))}

            <div className={styles.operation}>
              <PlusCircleOutlined
                onClick={() => {
                  const packageList = form.getFieldValue('packageList');
                  console.log(packageList);
                  form.setFieldsValue({
                    packageList: [
                      ...packageList,
                      {
                        expressCompanyCode: '',
                        skuInfoList: [
                          {
                            skuId: '',
                            quantity: 1,
                          },
                        ],
                      },
                    ],
                  });
                }}
              />
              <MinusCircleOutlined
                onClick={() => {
                  remove(fields[fields.length - 1].name);
                }}
              />
            </div>
          </>
        )}
      </Form.List>
    </Form>
  );
};
const FormWarpper = forwardRef(FormComponent);

const UpdateStatusModal = (props, ref) => {
  const { companys } = props;
  const formRef = useRef();
  const [visible, setVisible] = useState(false);
  const [confirmLoading, setConfirmLoading] = useState(false);
  const [record, setRecord] = useState();

  const open = item => {
    setVisible(true);
    setRecord(item);
  };

  const onCancel = () => {
    setVisible(false);
    setConfirmLoading(false);
    formRef.current.form.resetFields();
  };

  const onOk = () => {
    formRef.current.form.validateFields().then(values => {
      console.log('fieldsValue :>>', values);
    });
  };

  useImperativeHandle(ref, () => ({
    open,
  }));

  const modalProps = {
    title: '填写物流信息',
    height: 500,
    visible,
    confirmLoading,
    onCancel,
    onOk,
  };

  return (
    <Modal {...modalProps}>
      {record ? <FormWarpper ref={formRef} record={record} companys={companys} /> : ''}
    </Modal>
  );
};

export default forwardRef(UpdateStatusModal);
