import { stringify } from 'querystring';
import _ from 'lodash';
import request from '@/utils/request';
import config from '../../../../config/env.config';

// 待发货订单
export async function queryToSend(params) {
  const {
    data: { current, records, total, size },
  } = await request.post('/api/kdsp/op/mch-order/list-v2', {
    prefix: config.kdspApi,
    data: stringify(_.omitBy(params, v => !v)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return {
    current,
    data: records.map(v => ({ ...v, logisticsStatus: `_${v.logisticsStatus}` })),
    total,
    pageSize: size,
  };
}

// 快递公司
export async function queryExpress() {
  const { data = [] } = await request.get('/api/kdsp/op/express/list', {
    prefix: config.kdspApi,
  });
  return data;
}

export async function updateExpress(params) {
  return request.post('/api/kdsp/op/mch-order/update-express-info', {
    prefix: config.kdspApi,
    data: params,
  });
}

export async function getGoods(orderId) {
  const { data } = await request.get(`/api/kdsp/op/mch-order/skus?orderId=${orderId}`, {
    prefix: config.kdspApi,
  });
  return data;
}
export async function getLogistics(orderId) {
  const { data } = await request.get(`/api/kdsp/op/mch-order/logistics-skus?orderId=${orderId}`, {
    prefix: config.kdspApi,
  });
  return data;
}
export async function uploadFile(file) {
  const params = new FormData();
  params.append('file', file);
  const { data } = await request.post('/api/kdsp/op/mch-order/order-logistics-batch-import', {
    data: params,
    prefix: config.kdspApi,
  });
  return data;
}
export function downTemplate() {
  window.location.href = `${config.kdspApi}/api/kdsp/op/mch-order/import-mould-download`;
}
export function downOrder(params) {
  window.location.href = `${config.kdspApi}/api/kdsp/op/mch-order/order-export?${stringify(
    params,
  )}`;
}
