import { InputNumber, InputRef } from 'antd';
import { Button, Form, Input, Popconfirm, Table } from 'antd';
import type { FormInstance } from 'antd/es/form';
import React, { useContext, useEffect, useRef, useState } from 'react';

const EditableContext = React.createContext<FormInstance<any> | null>(null);

interface Item {
  key: string;
  name: string;
  age: string;
  address: string;
}

interface EditableRowProps {
  index: number;
}

const EditableRow: React.FC<EditableRowProps> = ({ index, ...props }) => {
  // console.log('==========> index', props);
  // const [form] = Form.useForm();
  // console.log('==========>props', props)
  return (
    // <Form form={form} component={false}>
    //   <EditableContext.Provider value={form}>
        <tr {...props} />
      // </EditableContext.Provider>
    // </Form>
  );
};

interface EditableCellProps {
  rowIndex: number;
  title: React.ReactNode;
  editable: boolean;
  children: React.ReactNode;
  dataIndex: keyof Item;
  record: Item;
  handleSave: (record: Item) => void;
}

const EditableCell: React.FC<EditableCellProps> = (props) => {
  const {
    rowIndex,
    title,
    editable,
    children,
    dataIndex,
    record,
    handleSave,
    ...restProps
  } = props;
  // console.log(props);
  const form = useContext(EditableContext)!;
  const save = async () => {
    try {
      console.log(rowIndex);
      const { tableList } = await form.validateFields();
      handleSave(tableList);
    } catch (errInfo) {
      console.log('Save failed:', errInfo);
    }
  };

  const childNode = <Form.Item
    style={{ margin: 0 }}
    name={['tableList', rowIndex, dataIndex]}
    initialValue={record[dataIndex]}
    rules={[ { required: true, message: `${title} is required.` }]}>
    <InputNumber onBlur={save} />
  </Form.Item>

  return <td {...restProps}>{childNode}</td>;
};

type EditableTableProps = Parameters<typeof Table>[0];

interface DataType {
  supplyPrice: number;
  commissionRate: number;
  marketPrice: number;
  salePrice: number;
  stock: number;
  productStockWarning: number;
}

type ColumnTypes = Exclude<EditableTableProps['columns'], undefined>;

const EditFormTable: React.FC = () => {
  const [dataSource, setDataSource] = useState<DataType[]>([
    {
      supplyPrice: 100,
      commissionRate: 20,
      marketPrice: 32,
      salePrice: 100,
      stock: 100,
      productStockWarning: 100,
    },
    {
      supplyPrice: 100,
      commissionRate: 20,
      marketPrice: 32,
      salePrice: 100,
      stock: 100,
      productStockWarning: 100,
    }
  ]);
  // const form = useContext(EditableContext)!;
  const [form] = Form.useForm();
  

  const [count, setCount] = useState(2);

  const handleDelete = (key: React.Key) => {
    const newData = dataSource.filter(item => item.key !== key);
    setDataSource(newData);
  };

  const defaultColumns: (ColumnTypes[number] & { editable?: boolean; dataIndex: string })[] = [
    {
      title: '供货价',
      dataIndex: 'supplyPrice',
      editable: true,
    },
    {
      title: '佣金费率',
      dataIndex: 'commissionRate',
      editable: true,
    },
    {
      title: '市场价',
      dataIndex: 'marketPrice',
      editable: true,
    },
    {
      title: '销售价',
      dataIndex: 'salePrice',
      editable: true,
    },
    {
      title: '库存',
      dataIndex: 'stock',
      editable: true,
    },
    {
      title: '库存预警阈值',
      dataIndex: 'productStockWarning',
      editable: true,
    },
  ];

  const handleAdd = () => {
    console.log(form.getFieldsValue());
    // const newData: DataType = {
    //   key: count,
    //   supplyPrice: 200,
    //   commissionRate: 20,
    //   marketPrice: 32,
    //   salePrice: 100,
    //   stock: 100,
    //   productStockWarning: 100,
    // };
    // setDataSource([...dataSource, newData]);
    // setCount(count + 1);
  };

  const handleSave = (row: DataType[]) => {
    console.log('============>row', row);
    // const newData = [...dataSource];
    // const index = newData.findIndex(item => row.key === item.key);
    // const item = newData[index];
    // newData.splice(index, 1, {
    //   ...item,
    //   ...row,
    // });
    setDataSource([...row]);
  };

  const components = {
    body: {
      row: EditableRow,
      cell: EditableCell,
    },
  };
  // 根据这里做判断渲染表格
  const columns = defaultColumns.map((col, colIndex) => {
    if (!col.editable) {
      return col;
    }
    return {
      ...col,
      onCell: (record: DataType, rowIndex: number) => ({
        record,
        rowIndex,
        editable: col.editable,
        dataIndex: col.dataIndex,
        title: col.title,
        handleSave,
      }),
    };
  });
  
  return (
    <div>
      <Button onClick={handleAdd} type="primary" style={{ marginBottom: 16 }}>
        Add a row
      </Button>
      <Form form={form} component={false}>
        <EditableContext.Provider value={form}>
          <Table
            pagination={false}
            size="small"
            components={components}
            bordered
            dataSource={dataSource}
            rowKey={(row, rowInd) => rowInd}
            columns={columns as ColumnTypes}
          />
        </EditableContext.Provider>
      </Form>
    </div>
  );
};

export default EditFormTable;