import { ConsoleSqlOutlined, MinusCircleOutlined, PlusOutlined } from '@ant-design/icons';
import { Button, Form, Input, Select, Space, Modal } from 'antd';
import React, { useState, forwardRef, useImperativeHandle, useEffect } from 'react';
import { useParams } from 'react-router-dom';
import { formItemLayout } from '../config';
import EditFormTable from './EditFormTable';

const { Option } = Select;


interface SpecItem {
  specId: number;
  specName: string;
}
interface PropsType {
  editData: any;
  specList: Array<SpecItem>;
}

const SpecificationTemplate = (props, _) => {
  const { specList, label, name, selectName, specName, form } = props;


  const handleChange = (val, option) => {
    const optionSpecName = option ? option.specName : null;
    form.setFieldsValue({ [selectName]: optionSpecName });
  };

  const bundlePlusAddSpecEvent = (addCallback: () => void) => {
    const specId = form.getFieldValue(name);
    if (!specId) {
      Modal.warning({
        maskClosable: true,
        title: `请先选择${label}！`,
      });
      return;
    }
    console.log(specId);
    addCallback();
  }

  return <>
    <Form.Item name={name} label={label}>
      <Select
        allowClear
        options={specList}
        style={{ width: 200 }}
        fieldNames={{ label: 'specName', value: 'specId' }}
        placeholder={`请选择${label}`}
        showSearch
        filterOption={(input, option) => option.specName.toLowerCase().indexOf(input.toLowerCase()) >= 0}
        onChange={handleChange}
      />
    </Form.Item>
    <Form.Item name={selectName} hidden></Form.Item>
    <Form.List name={specName}>
      {(fields, { add, remove }) => (
        <>
          {fields.map((field, index) => (
            <Form.Item key={field.key} noStyle shouldUpdate={(prevValues, curValues) => false}>
              {() => (
                <Space key={field.key} align="baseline">
                  <Form.Item style={{ marginLeft: 10 }} name={[field.name, specName]}
                    rules={[{ required: true, message: '请输入规格名称' }]}
                  >
                    <Input placeholder="请输入规格名称" />
                  </Form.Item>
                  <MinusCircleOutlined onClick={() => remove(field.name)} />
                </Space>
              )}
            </Form.Item>
          ))}
          {fields.length < 3 && <Form.Item noStyle>
            <Button style={{ marginLeft: 10, marginBottom: 24 }} type="dashed" onClick={() => bundlePlusAddSpecEvent(add)} icon={<PlusOutlined />} />
          </Form.Item>}
        </>
      )}
    </Form.List>
  </>
}

const filterSpecData = skuList => skuList.reduce((originObj, item) => {
  if (item.firstSpecValue) {
    originObj.firstSpecValue.push({ firstSpecValue: item.firstSpecValue });
  }
  if (item.secondSpecValue) {
    originObj.secondSpecValue.push({ secondSpecValue: item.secondSpecValue });
  }
  return originObj;
}, {
  firstSpecValue: [],
  secondSpecValue: [],
});


const FormPriceOrStock = forwardRef((props: PropsType, ref) => {
  const { specList, editData } = props;
  const [form] = Form.useForm();
  const [specInitValue, setSpecInitValue] = useState({
    firstSpec: '',
    firstSpecId: null,
    firstSpecValue: [],
    secondSpec: '',
    secondSpecId: null,
    secondSpecValue: [],
  });

  const onFinish = (values: any) => {
    console.log('Received values of form:', values);
  };

  const onCheck = async () => {
    try {
      const values = await form.validateFields();
      return values;
    } catch (errorInfo) {
      return null;
    }
  };

  useImperativeHandle(ref, () => ({
    onCheck,
  }));
  const { id } = useParams<any>();
  useEffect(() => {
    if (+id !== 0) {
      if (!Object.keys(editData).length) return;
      const { skuList } = editData;
      const [oneItem] = skuList;
      // 根据接口过滤数据
      const { firstSpecValue, secondSpecValue } = filterSpecData(skuList);
      const specData = {
        firstSpec: oneItem.firstSpec,
        firstSpecId: oneItem.firstSpecId,
        firstSpecValue,
        secondSpec: oneItem.secondSpec,
        secondSpecId: oneItem.secondSpecId,
        secondSpecValue,
      };
      form.setFieldsValue(specData);
      setSpecInitValue(specData);
    }
  }, [id, editData]);

  return (
    // {...formItemLayout}
    <Form
      form={form}
      name="dynamic_form_nest_item"
      onFinish={onFinish}
      autoComplete="off"
      initialValues={specInitValue}
    >
      <SpecificationTemplate
        form={form}
        label="一级规格"
        name="firstSpecId"
        selectName="firstSpec"
        specName="firstSpecValue"
        specList={specList}
      />
      <SpecificationTemplate
        form={form}
        label="二级规格"
        name="secondSpecId"
        selectName="secondSpec"
        specName="secondSpecValue"
        specList={specList}
      />

      <Form.Item>
        <Button type="primary" htmlType="submit">
          Submit
        </Button>
      </Form.Item>

      <EditFormTable />

    </Form>
  );
});

export default FormPriceOrStock;
