import { Button, Upload, notification } from 'antd';
import React, { useState, useEffect, useRef } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import LogisticsForm from './components/LogisticsForm';
import OrderDetail from './components/OrderDetail';
import {
  queryToSend,
  queryExpress,
  getGoods,
  uploadFile,
  getLogistics,
  downTemplate,
  downOrder,
} from './service';

const TableList = props => {
  const [companys, setCompanys] = useState([]);
  const [LogisticsModalVisible, handleModalVisible] = useState(false);
  const [skuList, setSkuList] = useState([]);
  const [rowKeys, setRowKeys] = useState([]);
  const [LogisticsData, setLogisticsData] = useState([{}]);
  const [QueryData, setQueryData] = useState({});
  const actionRef = useRef();
  const columns = [
    {
      title: '订单ID',
      dataIndex: 'orderNo',
      key: 'orderNo',
      order: 6,
    },
    {
      title: '商品名称',
      dataIndex: 'skuName',
      key: 'skuName',
      order: 6,
      hideInTable: true,
    },
    {
      title: '交易时间',
      dataIndex: 'orderTime',
      key: 'orderTime',
      hideInSearch: true,
    },
    {
      title: '收货人手机',
      dataIndex: 'receiverPhone',
      key: 'receiverPhone',
      order: 4,
    },
    {
      title: '收货人姓名',
      dataIndex: 'receiverName',
      key: 'receiverName',
      order: 3,
    },
    {
      title: '收货地址',
      dataIndex: 'fullAddress',
      key: 'fullAddress',
      hideInSearch: true,
      width: 160,
    },
    {
      title: '订单状态',
      dataIndex: 'orderStatus',
      key: 'orderStatus',
      width: 200,
      hideInSearch: true,
      valueEnum: {
        12: '待发货',
        13: '待收货',
        21: '订单完成',
      },
    },
    {
      title: '订单开始时间',
      dataIndex: 'beginTime',
      key: 'beginTime',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: '订单结束时间',
      dataIndex: 'endTime',
      key: 'endTime',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: '操作',
      dataIndex: 'option',
      key: 'option',
      valueType: 'option',
      width: 120,
      render: (_, record) => (
        <React.Fragment>
          {
            <Button
              type="primary"
              style={{
                marginBottom: '10px',
              }}
              onClick={async () => {
                const skuListData = await getGoods(record.orderId);
                let logisticsData = [{}];
                setSkuList(skuListData);
                const data = await getLogistics(record.orderId);
                logisticsData = data.map(item => ({
                  selectedGoods: item.skus.map(sku => sku.orderSkuId),
                  selectedCompany: `${item.expressCompanyCode}-${item.expressCompanyName}`,
                  orderNum: item.deliveryNo,
                }));
                setLogisticsData(logisticsData);
                handleModalVisible(true);
              }}
            >
              更新物流信息
            </Button>
          }
        </React.Fragment>
      ),
    },
  ];

  const reload = () => {
    handleModalVisible(false);
    if (actionRef.current) {
      actionRef.current.reload();
    }
  };

  useEffect(() => {
    const getCompanys = async () => {
      const data = await queryExpress();
      setCompanys(data);
    };
    getCompanys();
  }, []);
  const expandedRowRender = record => <OrderDetail value={record.mchOrderSkuVoList} />;
  const getExpandId = data => {
    const tableData = data.map(item => {
      const temp = item;
      temp.mchOrderSkuVoList = temp.mchOrderSkuVoList?.map(order => ({
        ...order,
        orderStatus: item.orderStatus,
      }));
      return temp;
    });
    setRowKeys(data.map(item => item.orderId));
    return tableData;
  };
  const updateExpandId = (b, r) => {
    const newExp = b ? [...rowKeys, r.orderId] : rowKeys.filter(i => i !== r.orderId);
    setRowKeys(newExp);
  };
  const uploadProps = {
    name: 'file',
    customRequest(info) {
      const result = uploadFile(info.file);
      if (result) {
        notification.success({ message: '导入成功' });
      }
    },
    accept: '.xlsx',
    showUploadList: false,
  };

  const queryToSendFn = params => {
    const transformedParam = {
      ...params,
      logisticsStatus: props.type || 1,
      startTime: params.beginTime,
      pageNo: params.current,
      pageSize: params.pageSize || 20,
    };
    setQueryData(transformedParam);
    return queryToSend(transformedParam);
  };
  const searchRender = ({ searchText, resetText }, { form }) => {
    const exportBtn = [
      <Upload {...uploadProps}>
        <Button type="primary" style={{ marginRight: '10px' }} key="export">
          导入
        </Button>
      </Upload>,
      <Button
        type="primary"
        key="exportTemplate"
        onClick={downTemplate}
        style={{ marginRight: '10px' }}
      >
        导入模板下载
      </Button>,
    ];
    return [
      <Button
        key="search"
        type="primary"
        style={{ marginRight: '10px' }}
        onClick={() => {
          // eslint-disable-next-line no-unused-expressions
          form?.submit();
        }}
      >
        {searchText}
      </Button>,
      <Button
        key="rest"
        style={{ marginRight: '10px' }}
        onClick={() => {
          // eslint-disable-next-line no-unused-expressions
          form?.resetFields();
          setQueryData({});
        }}
      >
        {resetText}
      </Button>,
      props.type === 2 ? null : [...exportBtn],
    ];
  };

  const toolBarRenderFn = () => [
    props.type === 2 ? null : (
      <Button
        type="primary"
        onClick={() => {
          downOrder(QueryData);
        }}
      >
        导出数据
      </Button>
    ),
  ];
  return (
    <PageHeaderWrapper>
      <ProTable
        actionRef={actionRef}
        request={params => queryToSendFn({ ...params })}
        columns={columns}
        postData={getExpandId}
        expandedRowRender={expandedRowRender}
        expandedRowKeys={rowKeys}
        rowKey={r => r.orderId}
        onExpand={updateExpandId}
        toolBarRender={toolBarRenderFn}
        search={{
          collapsed: false,
          optionRender: searchRender,
        }}
      />
      <LogisticsForm
        onSubmit={reload}
        skuList={skuList}
        companys={companys}
        onCancel={() => handleModalVisible(false)}
        modalVisible={LogisticsModalVisible}
        value={LogisticsData}
      />
    </PageHeaderWrapper>
  );
};

export default TableList;
