import Vue from 'vue';
import VueRouter from 'vue-router';
import initService from '@/service/init.service';
import routes from './routes';

Vue.use(VueRouter);

// 解决跳转相同路由报错
const originalPush = VueRouter.prototype.push;
VueRouter.prototype.push = function push(location) {
  return originalPush.call(this, location).catch(err => err);
};

const originalReplace = VueRouter.prototype.replace;
VueRouter.prototype.replace = function replace(location) {
  return originalReplace.call(this, location).catch(err => err);
};

const scrollBehavior = (to, from, savedPosition) => {
  if (savedPosition) {
    return savedPosition;
  }
  return {
    x: 0,
    y: 0
  };
};

const router = new VueRouter({
  mode: 'history',
  routes,
  scrollBehavior
});
initService.init(router);

export default router;
