import config from '@/config';
import http from '@/service/httpDecorator';
import { saDeviceId } from '@/service/sa.service';
const { yxmGateway } = config;
const PAGE = 'home';
export const getBanner = () => {
  return http.get(`${yxmGateway}/api/kdsp/appconfig/${PAGE}/topinfo`);
};
//获取动态内容【金刚区、运营专区等】【金刚区、运营专区-横向，运营专区-竖向， 通栏】
export const getContent = () => {
  //页面：home-精选，discovery-发现，profile-我的
  return http.get(`${yxmGateway}/api/kdsp/appconfig/${PAGE}/content`);
};

export const getGoodsList = async data => {
  const scDeviceId = await saDeviceId();
  return http.get(`${yxmGateway}/api/kdsp/recommend/goods-list`, {
    params: data,
    customHeader: {
      scDeviceId
    }
  });
};

export const homeSearch = async data => {
  const scDeviceId = await saDeviceId();
  return http.post(`${yxmGateway}/api/kdsp/search/result`, data, {
    customHeader: {
      scDeviceId
    }
  });
};

// 搜索--大家都在搜的关键词
export const getTerms = data => {
  return http.get(`${yxmGateway}/vcc/app/mall/search/page`, data);
};
// 查询用户优惠券选择查询接口
export const getCouponChooseList = data => {
  return http.post(`${yxmGateway}/api/kdsp/coupon/activity/choose-list`, data);
};
