import request from '@/service/httpDecorator';
import config from '@/config';
import { saDeviceId } from '@/service/sa.service';
const { yxmGateway } = config;

const queryPayInfo = function(data) {
  return request.post(`${yxmGateway}/open/checkout`, data);
};
const prepay = async function(data) {
  const scDeviceId = await saDeviceId();
  return request.post(`${yxmGateway}/open/checkout/v2/prepay`, data, {
    customHeader: {
      scDeviceId
    },
    hideToast: true
  });
};

const pay = async function(data) {
  const scDeviceId = await saDeviceId();
  return request.post(`${yxmGateway}/open/checkout/v2/pay`, data, {
    customHeader: {
      scDeviceId
    },
    hideToast: true
  });
};

const queryPayStatus = function(data) {
  return request.post(`${yxmGateway}/open/checkout/v2/pay_status/query`, data);
};

const sendSms = function(data) {
  return request.post(`${yxmGateway}/open/checkout/send_sms`, data);
};

const desSalt = function() {
  return request.get(`${yxmGateway}/vcc/account/salt`);
};

const h5AppyUrl = function() {
  return request.get(`${yxmGateway}/vcc/xyqb_mall/app_url`);
};

const getCoupon = async function(params) {
  const scDeviceId = await saDeviceId();
  return request.post(`${yxmGateway}/open/checkout/pay_coupon_list`, params, {
    customHeader: {
      scDeviceId
    }
  });
};

const ocrFaceId = function(params) {
  return request.post(`${yxmGateway}/open/checkout/ocr_faceId`, params);
};

const getGoodsList = async function(data) {
  const scDeviceId = await saDeviceId();
  return request.get(`${yxmGateway}/vcc/xyqb/recommend/goods-list`, {
    params: data,
    hideLoading: true,
    customHeader: {
      scDeviceId
    }
  });
};

// KA流程节点
const kaGetNextUrl = function() {
  return request.get(`${yxmGateway}/api/kdsp/ka/process/get-next-url`);
};

const reissueContract = function(params) {
  return request.post(`${yxmGateway}/open/checkout/payReissueContract`, params);
};

export default {
  // 商品详情页面
  desSalt() {
    return request.get(`${yxmGateway}/vcc/account/salt`);
  }
};
const getCouponList = function(params) {
  return request.get(`${yxmGateway}/api/kdsp/appconfig/pay-succ-page/guide-stream`, { params });
};
// 获取用户手机号
const getPhoneNumber = function() {
  return request.get(`${yxmGateway}/api/kdsp/user/phone`);
};
export {
  pay,
  prepay,
  sendSms,
  desSalt,
  h5AppyUrl,
  getCoupon,
  ocrFaceId,
  queryPayInfo,
  getGoodsList,
  kaGetNextUrl,
  getCouponList,
  queryPayStatus,
  reissueContract,
  getPhoneNumber
};
