import Vue from 'vue';

import App from './App.vue';
import router from './router';
import store from './store';
import '@/service/svg.service';
import '@/service/cherryUI.service';
import './style/index.less';
import saService from '@/service/sa.service';
import Bridge from '@qg/js-bridge';
import * as Sentry from '@sentry/vue';
import { Integrations } from '@sentry/tracing';
import { release, dsn } from '../.sentryclirc';
import lazyload from '@qg/cherry-ui/src/lazyload/index';
import 'intersection-observer';
if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  Sentry.init({
    Vue,
    dsn,
    integrations: [
      new Integrations.BrowserTracing({
        routingInstrumentation: Sentry.vueRouterInstrumentation(router)
      })
    ],
    release,
    tracesSampleRate: 1.0, // 上报频率, 1最大, 0最小, 建议验证设置为1, 项目运行根据情况降低频率
    environment: process.env.NODE_ENV
  });
}
Vue.prototype.util = new Bridge();
Vue.prototype.$track = saService;
saService.init(router);
Vue.use(lazyload);
Vue.config.productionTip = false;
Vue.config.ignoredElements = ['wx-open-launch-weapp'];

new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app');
