import config from '@/config';
import http from '@/service/httpDecorator';
import qs from 'qs';
const { talosHost } = config;
const MINI_APP_ID = 'wxb3e6270e1b1e0bc7'; // 羊小咩
// const MINI_APP_ID = 'wxe16bf9293671506c'; // 狼大呜

export default {
  // 查询商品sku详情
  detailInfo: params => {
    return http.post(`${talosHost}/api/kdsp/activity/activity-goods-special/detail`, { ...params });
  },
  checkGroupBuyCreateOrder: params => {
    return http.post(`${talosHost}/api/kdsp/checkCanOpenJoinGroup?${qs.stringify(params)}`);
  },
  // 详情图片
  getDetailPic: url => {
    return http.get(url, { strategy: 'default', hideLoading: 1, skip: 1, hideToast: 1 });
  },
  // 商品详情地址列表
  addrList(data) {
    return http.get(`${talosHost}/api/kdsp/addr/receiver/list`, data, {
      hideLoading: true
    });
  },

  // 查询活动模板列表-根据活动id
  getTemplateList(activityId) {
    return http.get(`${talosHost}/api/kdsp/activity/activity-goods-special/template-list`, {
      params: { activityId }
    });
  },
  // 入口活动列表
  getGoodsList(params) {
    return http.get(`${talosHost}/api/kdsp/activity/activity-goods-special/goods-list/v2`, {
      params
    });
  },
  getWxConfig(url = window.location.href.split('#')[0]) {
    return http.post(`${talosHost}/api/kdsp/wx/mp/getJsapiSign`, {
      url: url,
      appId: 'wx2f44c7fe7b08458d'
    });
  },
  getScheme(params) {
    return http.get(
      `${talosHost}/api/kdsp/ka/info/getShareMiniUrl`,
      {
        params,
        headers: {
          'qg-tenant-id': 560761, // 羊小咩租户ID
          'mini-app-id': MINI_APP_ID // 羊小咩小程序appid
        }
      },
      { hideLoading: true }
    );
  },
  // 获取百人团订单
  getGroupOrderList(params) {
    return http.get(`${talosHost}/api/kdsp/group-order/list`, { params });
  },
  // 获取小程序码
  getQrcodeUrl(params) {
    const qsString = qs.stringify(params);
    return http.get(`${talosHost}/api/kdsp/playBill/getMakePicData?${qsString}`, {
      headers: {
        'qg-tenant-id': 560761, // 羊小咩租户ID
        'mini-app-id': MINI_APP_ID // 羊小咩小程序appid
      }
    });
  },
  getGroupShareInfo(orderNo) {
    return http.get(`${talosHost}/api/kdsp/groupShareInfo?orderNo=${orderNo}`);
  },
  getPlayBillUrl(m) {
    return http.get(`http://192.168.25.122/api/kdsp/playBill/getPlayBillUrl?m=${m}`);
  },
  makePlayBillPicUrl(activityInfoId) {
    return http.get(
      `http://192.168.25.122/api/kdsp/activity/activity-info/makePlayBillPicUrl?activityInfoId=${activityInfoId}`
    );
  }
};
