import http from '@/service/httpDecorator';
import config from '@/config';
const { yxmGateway, faceHost } = config;

export default {
  // 获取信用钱包用户信息
  getXhkInfo() {
    return http.get(`${yxmGateway}/api/kdsp/profile/vcc/user-account`);
  },
  getUserInfo() {
    return http.get(`${yxmGateway}/api/kdsp/user/about`);
  }
};

// 发送短信
export const smsCode = param => {
  const data = { ...param, smsMerchant: 'XIN_YONG_QIAN_BAO' };
  return http.post(`${yxmGateway}/vcc/usercenter/send_vcc_sms_code`, data);
};
// KA流程节点
export const kaGetNextUrl = params => {
  let options = {
    sonVccChannel: true
  };
  return http.get(`${yxmGateway}/api/kdsp/ka/process/get-next-url`, { params }, options);
};
// 验证短信并登录
export const friendLogin = data => {
  return http.post(`${yxmGateway}/vcc/usercenter/fast_login_by_sms_code`, data);
};

// 验证短信类型
export const captchaType = data => {
  return http.post(`${yxmGateway}/vcc/usercenter/captcha_type`, data);
};
// 获取图形验证
export const captcha = () => {
  return http.get(`${yxmGateway}/vcc/usercenter/qg_captcha`);
};

export const getFaceUrl = params => {
  return http.get(`${faceHost}/auth-center/ex/face/h5/auth_url.json`, { params });
};
