const crypto = require('crypto');
const pkgInfo = require('./package.json');
const project = pkgInfo.name;
const VERSION = process.env.GIT_VERSION || '1.0.0'
const hashName = crypto
  .createHash('md5')
  .update(project)
  .digest('hex')
  .substr(0, 8);

module.exports = {
  org: 'sentry',
  project,
  authToken: '3f1f6f3789594e3a81280c1cd8d4d1008037a7abad714698b60b6f358c3d7562',
  url: 'http://newsentry.quantgroups.com',
  release: `${project}@${VERSION}`,
  ignore: ['node_modules', 'tests'],
  silent: true,
  include: [
    {
      paths: ['./dist/js'],
      urlPrefix: `https://misc.lkbang.net/${hashName}/`
    }
  ]
};
