/*
 * @Description:
 * @Date: 2020-12-01 18:06:18
 * @LastEditors: gzw
 * @LastEditTime: 2021-08-03 15:53:02
 */
import { parseTime } from '@/service/utils.service';

export function handleRemainTime(start, end) {
  const startTime = (start ? new Date(start.replace(/-|\./g, '/')) : new Date()).getTime();
  const endTime = (end ? new Date(end.replace(/-|\./g, '/')) : new Date()).getTime();
  return [endTime - startTime, startTime, endTime];
}

export function handleDateFormat(start, end) {
  const dateArr = handleRemainTime(start, end);
  const isDay = dateArr[0] > 60 * 60 * 1000 * 23;
  const formatExp = isDay ? '{m}.{d}' : '{h}:{i}';
  return { isDay, dateFormat: parseTime(dateArr[1], formatExp) };
}
