import Vue from 'vue';

import App from './App.vue';
import router from './router';
import store from './store';
import '@/service/svg.service';
import '@/service/cherryUI.service';
import './style/index.less';
import saService from '@/service/sa.service';
import Bridge from '@qg/js-bridge';
// import { init as sentryInit } from '@sentry/vue';
import lazyload from '@qg/cherry-ui/src/lazyload/index';
import 'intersection-observer';
// if (process.env.SENTRY_ENV === 'prod' && process.env.NODE_ENV === 'production') {
//   sentryInit({
//     Vue,
//     dsn: 'https://d36508238b7c4e5fa8306948b52948e1@sentry.q-gp.com/11', // 项目设置中的Client Keys
//     release: `group-buy-ui@${process.env.GIT_VERSION || '1.0.0'}`, // 项目名加版本号
//     tracesSampleRate: 0.5, // 上报频率, 1最大, 0最小, 建议验证设置为1, 项目运行根据情况降低频率
//     environment: process.env.NODE_ENV
//   });
// }
Vue.prototype.util = new Bridge();
Vue.prototype.$track = saService;
saService.init(router);
Vue.use(lazyload);
Vue.config.productionTip = false;
Vue.config.ignoredElements = ['wx-open-launch-weapp'];

new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app');
