/*
 * @Description: 根据商品来源匹配
 * @Date: 2021-04-26 17:47:15
 * @LastEditors: gzw
 * @LastEditTime: 2022-06-28 17:41:02
 */
// const aliRule =
//   '?x-oss-process=image/resize,l_180,s_180,m_mfit/quality,q_70/interlace,1';

const rules = [
  {
    name: 'ali',
    reg: 'img.lkbang',
    rule: [
      `?x-oss-process=image/resize,l_220,s_220,m_mfit/quality,q_70/interlace,1`, // png 需要改尺寸
      `?x-oss-process=image/resize,l_360,s_360,m_mfit/quality,q_70/interlace,1`
    ]
  },
  {
    name: 'qiniu',
    reg: 'kdspstatic',
    rule: [
      '?imageMogr2/thumbnail/220x220/quality/75/interlace/1', // png 需要改尺寸
      '?imageMogr2/thumbnail/360x360/quality/75/interlace/1'
    ]
  },
  {
    name: 'jd',
    reg: '360buyimg',
    rule: ['!q75.dpg', '!q75.dpg'],
    resize: [
      { from: 'jfs', to: 's220x220_jfs' },
      { from: 'jfs', to: 's360x360_jfs' }
    ]
  }
  // {
  //   name: 'tencent',
  //   reg: 'img.lkbang',
  //   rule: [
  //     '?imageMogr2/thumbnail/220x220/quality/75/interlace/1',
  //     '?imageMogr2/thumbnail/360x360/quality/75/interlace/1'
  //   ]
  // }
];

export default function Img2Thumb(url, level = 0) {
  if (!url) return '';
  url = url.replace('http://', 'https://');
  if (url.indexOf('imageMogr2') > -1 || url.indexOf('.dpg') > -1) return url;
  let rule = '';
  for (let idx = 0; idx < rules.length; idx++) {
    const item = rules[idx];
    if (url.indexOf(item.reg) > -1) {
      rule = item;
      break;
    }
  }
  if (!rule) return url;
  if (rule.resize) url = url.replace(rule.resize[level].from, rule.resize[level].to);
  return url + rule.rule[level];
}
