import * as types from './type';
import groupBuy from '@/api/groupBuy';
import { isWxMp } from '@/service/validation.service';
import { paramsParentheses } from '@/service/utils.service';
const state = {
  header: true,
  title: '支付中心',
  loading: false,
  meta: {},
  keepAliveMap: [],
  isPrimordialBrowser: false, // 是否是原生浏览器
  isWeixinBrowser: false, // 是否是微信浏览器
  showShare: false, // 是否打开底部分享showShare
  shareInfo: {}, // 分享信息
  goodsShareInfo: null
};

// getters
const getters = {};

// actions
const actions = {
  change_header({ commit }, header) {
    commit(types.CHANGE_HEADER, header);
  },
  change_title({ commit }, title) {
    commit(types.CHANGE_TITLE, title);
  },
  change_meta({ commit }, meta) {
    commit(types.CHANGE_META, meta);
  },
  change_loading({ commit }, loading) {
    commit(types.CHANGE_LOADING, loading);
  },
  add_keep_alive({ commit }, name) {
    commit(types.ADD_KEEP_ALIVE, name);
  },
  change_show_mini_app_guide({ commit }, obj) {
    commit(types.CHANGE_SHOW_MINI_APP_GUIDE, obj);
  },
  change_is_weixin_browser({ commit }, bool) {
    commit(types.CHANGE_IS_WEIXIN_BROWSER, bool);
  },
  goods_share_open({ commit }, options) {
    commit(types.GOODS_SHARE_OPEN, options);
  },
  goods_share_close({ commit }) {
    commit(types.GOODS_SHARE_CLOSE);
  },
  goods_send_shareinfo({ commit }, options) {
    commit(types.GOODS_SEND_SHAREINFO, options);
  }
};

// mutations
const mutations = {
  [types.CHANGE_HEADER](state, header) {
    if (header !== undefined) {
      state.header = header;
    }
  },
  [types.CHANGE_LOADING](state, loading) {
    state.loading = loading;
  },
  [types.CHANGE_TITLE](state, title) {
    if (title) {
      state.title = title;
    }
    document.title = state.title;
  },
  [types.CHANGE_META](state, meta) {
    for (let i in meta) {
      state.meta[i] = meta[i];
    }
  },
  [types.ADD_KEEP_ALIVE](state, name) {
    const keepAliveMap = state.keepAliveMap;
    keepAliveMap.push(name);
    state.keepAliveMap = [...new Set(keepAliveMap)];
  },
  [types.DEL_KEEP_ALIVE](state, name) {
    state.keepAliveMap.splice(
      state.keepAliveMap.findIndex(item => item === name),
      1
    );
  },
  [types.CLEAR_KEEP_ALIVE](state) {
    state.keepAliveMap = [];
  },
  [types.CHANGE_IS_WEIXIN_BROWSER](state, bool) {
    state.isWeixinBrowser = bool;
  },
  [types.CHANGE_SHOW_MINI_APP_GUIDE](state, { bool, pointer }) {
    state.isPrimordialBrowser = bool;
    if (bool) {
      // 需要取反
      // 如果非app webview并且非小程序webview，直接拦截提示，到小程序操作
      // paramsParentheses(window.location.href);
      pointer.$dialog({
        message: '请在微信小程序中参与此活动哦~',
        showCancelButton: false,
        confirmButtonText: '打开微信小程序',
        onConfirm: () => {
          // todo 跳转到小程序
          let getScheme = async function() {
            const [res] = await groupBuy.getScheme({
              miniUrl: 'pages/groupbuy/webview',
              // miniUrl: 'pages/product/goodDetail',
              params: `from=groupBuy&url=${encodeURIComponent(
                JSON.stringify(paramsParentheses(pointer))
              )}`
            });
            const url = res;
            window.location.href = url; // todo 需要验证
          };
          getScheme();
          getScheme = null;
        }
      });
    }
  },
  [types.GOODS_SHARE_OPEN](state, options) {
    if (isWxMp) {
      state.shareInfo = options;
      state.showShare = true;
    }
  },
  [types.GOODS_SHARE_CLOSE](state) {
    state.showShare = false;
  },
  [types.GOODS_SEND_SHAREINFO](state, options) {
    state.goodsShareInfo = options;
  }
};

export default {
  state,
  getters,
  actions,
  mutations
};
