import config from '@/config';
import http from '@/service/httpDecorator';
import { encryption } from '@/service/encrypt';
const { talosHost } = config;

export default {
  // 订单列表
  orderList(data) {
    // TODO 测试
    return http.get(`${talosHost}/api/kdsp/order-info/list/query`, { params: data });
  },
  // 用户订单确认收货接口
  orderConfirm(data) {
    return http.post(`${talosHost}/api/kdsp/order-info/receipt/confirm`, data);
  },
  // 用户订单取消接口【未付款】
  orderCancel(data) {
    return http.post(`${talosHost}/api/kdsp/order-info/cancel`, data);
  },
  // 用户订单取消接口【未发货】
  orderUnfilledCancel(data) {
    return http.get(`${talosHost}/api/kdsp/order-info/unfilled/cancel`, { params: data });
  },
  // 订单取消原因查询接口
  orderCancelReason(params) {
    return http.get(`${talosHost}/api/kdsp/order-info/cancel-reason/query`, { params });
  },
  // 订单详情查询接口
  orderDetail(data) {
    return http.get(`${talosHost}/api/kdsp/order-info/detail/query`, { params: data });
  },
  // 物流详情查询接口
  expressDetail(data) {
    return http.get(`${talosHost}/api/kdsp/logistics/list`, { params: data });
  },
  // 我的 查询各状态订单数量
  orderInfo() {
    return http.get(`${talosHost}/api/kdsp/order-info/status-number`);
  },
  confirmOrder(data) {
    return http.post(`${talosHost}/api/kdsp/shop-cart/order-confirm/page/activity`, data);
  },

  orderSubmit(data) {
    return http.post(`${talosHost}/api/kdsp/order-info/e/hundredGroupSubmit`, encryption(data));
  },
  // 物流公司列表
  companyList() {
    return http.get(`${talosHost}/api/kdsp/logistics/kd100/company-list`);
  },
  // 售后原因查询
  applyReason(data) {
    return http.get(`${talosHost}/api/kdsp/after-service/apply-reason`, { params: data });
  },
  // 售后退款金额试算
  refundAmount(data) {
    return http.get(`${talosHost}/api/kdsp/after-service/refund-amount`, { params: data });
  },
  // 提交申请售后
  applySubmit(data) {
    return http.post(`${talosHost}/api/kdsp/after-service/apply`, data);
  },
  // 订单申请退款
  refundKepler(data) {
    return http.post(`${talosHost}/api/kdsp/order-info/apply-refund`, data);
  },
  // 查看售后详情
  afterDetail(data) {
    return http.get(`${talosHost}/api/kdsp/after-service/detail`, { params: data });
  },
  // 售后取消
  applyCancel(data) {
    return http.post(`${talosHost}/api/kdsp/after-service/cancel`, data);
  },
  // 售后退货物流单信息填写 after-service/add-delivery-no
  addDeliveryNo(data) {
    return http.post(`${talosHost}/api/kdsp/after-service/add-delivery-no`, data);
  },
  // 售后列表  after-service/list
  afterList(data) {
    return http.get(`${talosHost}/api/kdsp/after-service/service/list`, { params: data });
  },
  // 售后催办 after-service/reminder
  afterReminder(data) {
    return http.get(`${talosHost}/api/kdsp/after-service/reminder`, { params: data });
  },
  //查询售后是否在有效期
  applyExpired(data) {
    return http.get(`${talosHost}/api/kdsp/after-service/expired`, { params: data });
  },
  // 获取七牛token
  getQiniuToken(data) {
    return http.get(`${talosHost}/api/kdsp/common/upload/token`, { params: data });
  }
};
