import Vue from 'vue';

import App from './App.vue';
import router from './router';
import store from './store';
import '@/service/svg.service';
import '@/service/cherryUI.service';
import './style/index.less';
import saService from '@/service/sa.service';
import Bridge from '@qg/js-bridge';
import Raven from 'raven-js';
import RavenVue from 'raven-js/plugins/vue';
import { release } from '../.sentryclirc';
import lazyload from '@qg/cherry-ui/src/lazyload/index';
if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  Raven.config('//21779c2dcb594299bdc803c5560cfecd@sentry.q-gp.com/60', {
    release,
    environment: process.env.NODE_ENV
  })
    .addPlugin(RavenVue, Vue)
    .install();
}
Vue.prototype.util = new Bridge();
Vue.prototype.$track = saService;
saService.init(router);
Vue.use(lazyload);
Vue.config.productionTip = false;
Vue.config.ignoredElements = ['wx-open-launch-weapp'];

new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app');
