export default {
  get(key) {
    let result = window.sessionStorage.getItem(key);
    try {
      return JSON.parse(result);
    } catch (e) {
      return result;
    }
  },
  set(key, value) {
    let toString = Object.prototype.toString;
    if (toString.call(value) === '[object Array]' || toString.call(value) === '[object Object]') {
      value = JSON.stringify(value);
    }
    return window.sessionStorage.setItem(key, value);
  },
  remove(key) {
    return window.sessionStorage.removeItem(key);
  },
  clear() {
    return window.sessionStorage.clear();
  }
};
