import cookies from 'js-cookie';
const option = {
  domain: window.location.host.indexOf('.q-gp.com') >= 0 ? '.q-gp.com' : ''
};
const Cookies = {
  get(key) {
    return cookies.get(key) || '';
  },
  set(key, value) {
    return cookies.set(key, value, option);
  },
  clear() {
    return Object.keys(cookies.get()).forEach(function(cookie) {
      Cookies.remove(cookie, option);
    });
  },
  remove(key) {
    return cookies.remove(key, option);
  }
};

export default Cookies;
